/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.service.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.QueryRule;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.core.meta.OntologyTermSynonymFactory;
import org.molgenis.ontology.roc.InformationContentService;
import org.molgenis.ontology.sorta.bean.OntologyTermHitEntity;
import org.molgenis.ontology.sorta.meta.OntologyTermHitMetaData;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.semanticsearch.string.NGramDistanceAlgorithm;
import org.molgenis.semanticsearch.string.Stemmer;

public class SortaServiceImpl
implements SortaService {
    private static final Set<String> ELASTICSEARCH_RESERVED_WORDS = Sets.newHashSet((Object[])new String[]{"or", "and", "if"});
    private static final String NON_WORD_SEPARATOR = "[^a-zA-Z0-9]";
    private static final String ILLEGAL_CHARACTERS_PATTERN = "[^a-zA-Z0-9 ]";
    private static final String FUZZY_MATCH_SIMILARITY = "~0.8";
    private static final String SINGLE_WHITESPACE = " ";
    private static final int MAX_NUMBER_MATCHES = 50;
    private static final int NUMBER_NGRAM_MATCHES = 10;
    public static final String SIGNIFICANT_VALUE = "Significant";
    public static final Character DEFAULT_SEPARATOR = Character.valueOf(';');
    public static final String DEFAULT_MATCHING_NAME_FIELD = "Name";
    public static final String DEFAULT_MATCHING_SYNONYM_PREFIX_FIELD = "Synonym";
    public static final String DEFAULT_MATCHING_IDENTIFIER = "Identifier";
    private final DataService dataService;
    private final InformationContentService informationContentService;
    private final OntologyTermHitMetaData ontologyTermHitMetaData;
    private final OntologyTermSynonymFactory ontologyTermSynonymFactory;

    public SortaServiceImpl(DataService dataService, InformationContentService informationContentService, OntologyTermHitMetaData ontologyTermHitMetaData, OntologyTermSynonymFactory ontologyTermSynonymFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.informationContentService = Objects.requireNonNull(informationContentService);
        this.ontologyTermHitMetaData = Objects.requireNonNull(ontologyTermHitMetaData);
        this.ontologyTermSynonymFactory = Objects.requireNonNull(ontologyTermSynonymFactory);
    }

    @Override
    public Iterable<Entity> getAllOntologyEntities() {
        Stream findAll = this.dataService.findAll("sys_ont_Ontology");
        return findAll.collect(Collectors.toList());
    }

    @Override
    public Entity getOntologyEntity(String ontologyIri) {
        return this.dataService.findOne("sys_ont_Ontology", new QueryImpl().eq("ontologyIRI", (Object)ontologyIri));
    }

    @Override
    public Entity getOntologyTermEntity(String ontologyTermIri, String ontologyIri) {
        Entity ontologyEntity = this.getOntologyEntity(ontologyIri);
        if (ontologyEntity != null) {
            return this.dataService.findOne("sys_ont_OntologyTerm", new QueryImpl().eq("ontologyTermIRI", (Object)ontologyTermIri).and().eq("ontology", (Object)ontologyEntity));
        }
        return null;
    }

    @Override
    public Iterable<Entity> findOntologyTermEntities(String ontologyIri, Entity inputEntity) {
        Entity ontologyEntity = this.getOntologyEntity(ontologyIri);
        if (ontologyEntity == null) {
            throw new IllegalArgumentException("Ontology IRI " + ontologyIri + " does not exist in the database!");
        }
        ArrayList<Entity> relevantEntities = new ArrayList<Entity>();
        ArrayList<QueryRule> rulesForOtherFields = new ArrayList<QueryRule>();
        ArrayList<QueryRule> rulesForOntologyTermFields = new ArrayList<QueryRule>();
        ArrayList<QueryRule> rulesForOntologyTermFieldsNGram = new ArrayList<QueryRule>();
        for (String attributeName : inputEntity.getAttributeNames()) {
            if (!StringUtils.isNotEmpty((CharSequence)inputEntity.getString(attributeName)) || attributeName.equalsIgnoreCase(DEFAULT_MATCHING_IDENTIFIER)) continue;
            if (this.isAttrNameValidForLexicalMatch(attributeName)) {
                String stemmedQueryString = this.stemQuery(inputEntity.getString(attributeName));
                if (!StringUtils.isNotEmpty((CharSequence)stemmedQueryString)) continue;
                rulesForOntologyTermFields.add(new QueryRule("ontologyTermSynonym", QueryRule.Operator.FUZZY_MATCH, this.fuzzyMatchQuerySyntax(stemmedQueryString)));
                rulesForOntologyTermFieldsNGram.add(new QueryRule("ontologyTermSynonym", QueryRule.Operator.FUZZY_MATCH_NGRAM, stemmedQueryString));
                continue;
            }
            QueryRule queryAnnotationName = new QueryRule("name", QueryRule.Operator.EQUALS, attributeName);
            QueryRule queryAnnotationValue = new QueryRule("value", QueryRule.Operator.EQUALS, inputEntity.getString(attributeName));
            if (!rulesForOtherFields.isEmpty()) {
                rulesForOtherFields.add(new QueryRule(QueryRule.Operator.OR));
            }
            rulesForOtherFields.add(new QueryRule(Arrays.asList(queryAnnotationName, new QueryRule(QueryRule.Operator.AND), queryAnnotationValue)));
        }
        if (!rulesForOtherFields.isEmpty()) {
            this.annotationMatchOntologyTerms(inputEntity, ontologyEntity, relevantEntities, rulesForOtherFields);
        }
        if (!rulesForOntologyTermFields.isEmpty()) {
            int pageSize = 50 - relevantEntities.size();
            this.lexicalMatchOntologyTerms(ontologyIri, inputEntity, ontologyEntity, pageSize, rulesForOntologyTermFields, relevantEntities);
        }
        if (!rulesForOntologyTermFieldsNGram.isEmpty()) {
            this.lexicalMatchOntologyTerms(ontologyIri, inputEntity, ontologyEntity, 10, rulesForOntologyTermFieldsNGram, relevantEntities);
        }
        relevantEntities.sort((entity_1, entity_2) -> entity_2.getDouble("Combined_Score").compareTo(entity_1.getDouble("Combined_Score")));
        return relevantEntities;
    }

    private void annotationMatchOntologyTerms(Entity inputEntity, Entity ontologyEntity, List<Entity> relevantEntities, List<QueryRule> rulesForOtherFields) {
        List ontologyTermAnnotationEntities = this.dataService.findAll("sys_ont_OntologyTermDynamicAnnotation", new QueryImpl(rulesForOtherFields).pageSize(Integer.MAX_VALUE)).collect(Collectors.toList());
        if (!ontologyTermAnnotationEntities.isEmpty()) {
            List<QueryRule> rules = Arrays.asList(new QueryRule("ontology", QueryRule.Operator.EQUALS, (Object)ontologyEntity), new QueryRule(QueryRule.Operator.AND), new QueryRule("ontologyTermDynamicAnnotation", QueryRule.Operator.IN, ontologyTermAnnotationEntities));
            Stream ontologyTermEntities = this.dataService.findAll("sys_ont_OntologyTerm", new QueryImpl(rules).pageSize(Integer.MAX_VALUE));
            List relevantOntologyTermEntities = ontologyTermEntities.map(ontologyTermEntity -> this.calculateNGromOTAnnotations(inputEntity, (Entity)ontologyTermEntity)).collect(Collectors.toList());
            relevantEntities.addAll(relevantOntologyTermEntities);
        }
    }

    private void lexicalMatchOntologyTerms(String ontologyIri, Entity inputEntity, Entity ontologyEntity, int pageSize, List<QueryRule> rulesForOntologyTermFields, List<Entity> relevantEntities) {
        QueryRule disMaxQueryRule = new QueryRule(rulesForOntologyTermFields);
        disMaxQueryRule.setOperator(QueryRule.Operator.DIS_MAX);
        List<QueryRule> finalQueryRules = Arrays.asList(new QueryRule("ontology", QueryRule.Operator.EQUALS, (Object)ontologyEntity), new QueryRule(QueryRule.Operator.AND), disMaxQueryRule);
        Stream<Entity> lexicalMatchedOntologyTermEntities = this.dataService.findAll("sys_ont_OntologyTerm", new QueryImpl(finalQueryRules).pageSize(pageSize)).map(ontologyTerm -> this.addLexicalScoreToMatchedEntity(inputEntity, (Entity)ontologyTerm, ontologyIri));
        lexicalMatchedOntologyTermEntities.forEach(matchedEntity -> {
            if (!relevantEntities.contains(matchedEntity)) {
                relevantEntities.add((Entity)matchedEntity);
            }
        });
    }

    Entity addLexicalScoreToMatchedEntity(Entity inputEntity, Entity ontologyTerm, String ontologyIri) {
        double maxNgramScore = 0.0;
        double maxNgramIDFScore = 0.0;
        for (String inputAttrName : inputEntity.getAttributeNames()) {
            String queryString = inputEntity.getString(inputAttrName);
            if (!StringUtils.isNotEmpty((CharSequence)queryString) || !this.isAttrNameValidForLexicalMatch(inputAttrName)) continue;
            Entity topMatchedSynonymEntity = this.findSynonymWithHighestNgramScore(ontologyIri, queryString, ontologyTerm);
            if (maxNgramScore < topMatchedSynonymEntity.getDouble("Score")) {
                maxNgramScore = topMatchedSynonymEntity.getDouble("Score");
            }
            if (!(maxNgramIDFScore < topMatchedSynonymEntity.getDouble("Combined_Score"))) continue;
            maxNgramIDFScore = topMatchedSynonymEntity.getDouble("Combined_Score");
        }
        OntologyTermHitEntity mapEntity = new OntologyTermHitEntity(ontologyTerm, (EntityType)this.ontologyTermHitMetaData);
        mapEntity.set("Score", maxNgramScore);
        mapEntity.set("Combined_Score", maxNgramIDFScore);
        return mapEntity;
    }

    private Entity calculateNGromOTAnnotations(Entity inputEntity, Entity ontologyTermEntity) {
        OntologyTermHitEntity mapEntity = new OntologyTermHitEntity(ontologyTermEntity, (EntityType)this.ontologyTermHitMetaData);
        for (Entity annotationEntity : ontologyTermEntity.getEntities("ontologyTermDynamicAnnotation")) {
            String annotationName = annotationEntity.getString("name");
            String annotationValue = annotationEntity.getString("value");
            for (String attributeName : inputEntity.getAttributeNames()) {
                if (!StringUtils.isNotEmpty((CharSequence)inputEntity.getString(attributeName)) || !StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)annotationName) || !StringUtils.equalsIgnoreCase((CharSequence)inputEntity.getString(attributeName), (CharSequence)annotationValue)) continue;
                mapEntity.set("Score", 100.0);
                mapEntity.set("Combined_Score", 100.0);
                return mapEntity;
            }
        }
        return mapEntity;
    }

    private Entity findSynonymWithHighestNgramScore(String ontologyIri, String queryString, Entity ontologyTermEntity) {
        Iterable entities = ontologyTermEntity.getEntities("ontologyTermSynonym");
        if (Iterables.size((Iterable)entities) > 0) {
            String cleanedQueryString = SortaServiceImpl.removeIllegalCharWithSingleWhiteSpace(queryString);
            ImmutableList synonymEntities = FluentIterable.from((Iterable)entities).transform(ontologyTermSynonymEntity -> {
                Entity mapEntity = this.ontologyTermSynonymFactory.create();
                mapEntity.set(ontologyTermSynonymEntity);
                String ontologyTermSynonym = SortaServiceImpl.removeIllegalCharWithSingleWhiteSpace(ontologyTermSynonymEntity.getString("ontologyTermSynonym"));
                mapEntity.set("Score", (Object)NGramDistanceAlgorithm.stringMatching((String)cleanedQueryString, (String)ontologyTermSynonym));
                return mapEntity;
            }).toSortedList((entity_1, entity_2) -> entity_2.getDouble("Score").compareTo(entity_1.getDouble("Score")));
            Entity firstMatchedSynonymEntity = (Entity)Iterables.getFirst((Iterable)synonymEntities, (Object)this.ontologyTermSynonymFactory.create());
            double topNgramScore = firstMatchedSynonymEntity.getDouble("Score");
            String topMatchedSynonym = firstMatchedSynonymEntity.getString("ontologyTermSynonym");
            for (Entity nextMatchedSynonymEntity : Iterables.skip((Iterable)synonymEntities, (int)1)) {
                String nextMatchedSynonym = nextMatchedSynonymEntity.getString("ontologyTermSynonym");
                StringBuilder tempCombinedSynonym = new StringBuilder();
                tempCombinedSynonym.append(topMatchedSynonym).append(SINGLE_WHITESPACE).append(nextMatchedSynonym);
                double newScore = NGramDistanceAlgorithm.stringMatching((String)cleanedQueryString, (String)SortaServiceImpl.removeIllegalCharWithSingleWhiteSpace(tempCombinedSynonym.toString()));
                if (!(newScore > topNgramScore)) continue;
                topNgramScore = newScore;
                topMatchedSynonym = tempCombinedSynonym.toString();
            }
            firstMatchedSynonymEntity.set("ontologyTermSynonym", (Object)topMatchedSynonym);
            firstMatchedSynonymEntity.set("Score", (Object)topNgramScore);
            firstMatchedSynonymEntity.set("Combined_Score", (Object)topNgramScore);
            Map<String, Double> weightedWordSimilarity = this.informationContentService.redistributedNGramScore(cleanedQueryString, ontologyIri);
            Set<String> synonymStemmedWords = this.informationContentService.createStemmedWordSet(topMatchedSynonym);
            Set<String> createStemmedWordSet = this.informationContentService.createStemmedWordSet(cleanedQueryString);
            createStemmedWordSet.stream().filter(originalWord -> Iterables.contains((Iterable)synonymStemmedWords, (Object)originalWord) && weightedWordSimilarity.containsKey(originalWord)).forEach(word -> firstMatchedSynonymEntity.set("Combined_Score", (Object)(firstMatchedSynonymEntity.getDouble("Combined_Score") + (Double)weightedWordSimilarity.get(word))));
            return firstMatchedSynonymEntity;
        }
        return null;
    }

    private String stemQuery(String queryString) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet uniqueTerms = Sets.newHashSet((Object[])queryString.toLowerCase().trim().split(NON_WORD_SEPARATOR));
        uniqueTerms.removeAll(NGramDistanceAlgorithm.STOPWORDSLIST);
        for (String word : uniqueTerms) {
            String afterStem;
            if (!StringUtils.isNotEmpty((CharSequence)word.trim()) || ELASTICSEARCH_RESERVED_WORDS.contains(word) || !StringUtils.isNotEmpty((CharSequence)(afterStem = Stemmer.stem((String)SortaServiceImpl.removeIllegalCharWithEmptyString(word))))) continue;
            stringBuilder.append(afterStem).append(SINGLE_WHITESPACE);
        }
        return stringBuilder.toString().trim();
    }

    private String fuzzyMatchQuerySyntax(String queryString) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String word : queryString.split(SINGLE_WHITESPACE)) {
            stringBuilder.append(word).append(FUZZY_MATCH_SIMILARITY).append(SINGLE_WHITESPACE);
        }
        return stringBuilder.toString().trim();
    }

    private static String removeIllegalCharWithSingleWhiteSpace(String string) {
        return string.replaceAll(ILLEGAL_CHARACTERS_PATTERN, SINGLE_WHITESPACE);
    }

    private static String removeIllegalCharWithEmptyString(String string) {
        return string.replaceAll(ILLEGAL_CHARACTERS_PATTERN, "");
    }

    private boolean isAttrNameValidForLexicalMatch(String attr) {
        return StringUtils.equalsIgnoreCase((CharSequence)attr, (CharSequence)DEFAULT_MATCHING_NAME_FIELD) || StringUtils.containsIgnoreCase((CharSequence)attr, (CharSequence)DEFAULT_MATCHING_SYNONYM_PREFIX_FIELD);
    }
}

