/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.job;

import org.molgenis.core.ui.menu.MenuReaderService;
import org.molgenis.data.DataService;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.jobs.JobExecutionUpdater;
import org.molgenis.jobs.Progress;
import org.molgenis.jobs.ProgressImpl;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.ontology.sorta.job.SortaJobExecution;
import org.molgenis.ontology.sorta.job.SortaJobImpl;
import org.molgenis.ontology.sorta.job.SortaJobProcessor;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.token.RunAsUserTokenFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class SortaJobFactory {
    @Autowired
    private DataService dataService;
    @Autowired
    private SortaService sortaService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private JobExecutionUpdater jobExecutionUpdater;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private MailSender mailSender;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private MenuReaderService menuReaderService;
    @Autowired
    private RunAsUserTokenFactory runAsUserTokenFactory;

    @RunAsSystem
    public SortaJobImpl create(SortaJobExecution jobExecution) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        ProgressImpl progress = new ProgressImpl((JobExecution)jobExecution, this.jobExecutionUpdater, this.mailSender);
        String username = jobExecution.getUser();
        RunAsUserToken runAsAuthentication = this.runAsUserTokenFactory.create("Job Execution", this.userDetailsService.loadUserByUsername(username), null);
        SortaJobProcessor matchInputTermBatchService = new SortaJobProcessor(jobExecution.getOntologyIri(), jobExecution.getSourceEntityName(), jobExecution.getResultEntityName(), (Progress)progress, this.dataService, this.sortaService, this.idGenerator, this.menuReaderService);
        return new SortaJobImpl(matchInputTermBatchService, (Authentication)runAsAuthentication, (Progress)progress, transactionTemplate);
    }
}

