/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;

public class SortaServiceUtil {
    private SortaServiceUtil() {
    }

    public static List<Map<String, Object>> getEntityAsMap(Iterable<? extends Entity> entities) {
        ArrayList<Map<String, Object>> docs = new ArrayList<Map<String, Object>>();
        for (Entity entity : entities) {
            docs.add(SortaServiceUtil.getEntityAsMap(entity));
        }
        return docs;
    }

    public static Map<String, Object> getEntityAsMap(Entity entity) {
        if (entity == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        for (Attribute attr : entity.getEntityType().getAtomicAttributes()) {
            if (attr.getDataType() == AttributeType.ONE_TO_MANY) continue;
            String attrName = attr.getName();
            Object object = entity.get(attrName);
            if (object instanceof Iterable) {
                ArrayList<Map<String, Object>> refEntities = new ArrayList<Map<String, Object>>();
                for (Object refEntity : (Iterable)object) {
                    if (!(refEntity instanceof Entity)) continue;
                    refEntities.add(SortaServiceUtil.getEntityAsMap((Entity)refEntity));
                }
                doc.put(attrName, refEntities);
                continue;
            }
            if (object instanceof Entity) {
                doc.put(attrName, SortaServiceUtil.getEntityAsMap((Entity)object));
                continue;
            }
            doc.put(attrName, object);
        }
        return doc;
    }
}

