/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.job;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.core.ui.menu.MenuReaderService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.jobs.Progress;
import org.molgenis.ontology.sorta.meta.MatchingTaskContentMetaData;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.util.ApplicationContextProvider;
import org.springframework.stereotype.Component;

@Component
public class SortaJobProcessor {
    private static final int ADD_BATCH_SIZE = 1000;
    private static final int PROGRESS_UPDATE_BATCH_SIZE = 50;
    private final DataService dataService;
    private final SortaService sortaService;
    private final IdGenerator idGenerator;
    private final AtomicInteger counter;
    private final MenuReaderService menuReaderService;

    SortaJobProcessor(DataService dataService, SortaService sortaService, IdGenerator idGenerator, MenuReaderService menuReaderService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.sortaService = Objects.requireNonNull(sortaService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.counter = new AtomicInteger(0);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
    }

    public Void process(String ontologyIri, String inputRepositoryName, String resultRepositoryName, Progress progress) {
        RunAsSystemAspect.runAsSystem(() -> {
            long maxCount = this.dataService.count(inputRepositoryName, (Query)new QueryImpl());
            progress.status("Matching " + maxCount + " input terms from " + inputRepositoryName + ".\nStoring results in " + resultRepositoryName);
            progress.setProgressMax((int)maxCount);
            MatchingTaskContentMetaData matchingTaskContentMetaData = (MatchingTaskContentMetaData)((Object)((Object)ApplicationContextProvider.getApplicationContext().getBean(MatchingTaskContentMetaData.class)));
            ArrayList entitiesToAdd = Lists.newArrayList();
            this.dataService.findAll(inputRepositoryName).forEach(inputRow -> {
                DynamicEntity resultEntity = new DynamicEntity((EntityType)matchingTaskContentMetaData){

                    protected void validateValueType(String attrName, Object value) {
                    }
                };
                resultEntity.set("inputTerm", inputRow);
                resultEntity.set("identifier", (Object)this.idGenerator.generateId());
                resultEntity.set("validated", (Object)false);
                entitiesToAdd.add(resultEntity);
                Iterable<Entity> ontologyTermEntities = this.sortaService.findOntologyTermEntities(ontologyIri, (Entity)inputRow);
                if (Iterables.size(ontologyTermEntities) > 0) {
                    Entity firstMatchedOntologyTerm = (Entity)Iterables.getFirst(ontologyTermEntities, (Object)new DynamicEntity((EntityType)matchingTaskContentMetaData));
                    resultEntity.set("matchTerm", firstMatchedOntologyTerm.get("ontologyTermIRI"));
                    resultEntity.set("score", firstMatchedOntologyTerm.get("Score"));
                } else {
                    resultEntity.set("score", (Object)0.0);
                }
                if (entitiesToAdd.size() >= 1000) {
                    this.dataService.add(resultRepositoryName, entitiesToAdd.stream());
                    entitiesToAdd.clear();
                }
                this.counter.incrementAndGet();
                if (this.counter.get() % 50 == 0) {
                    progress.progress(this.counter.get(), "Processed " + this.counter + " input terms.");
                }
            });
            if (!entitiesToAdd.isEmpty()) {
                this.dataService.add(resultRepositoryName, entitiesToAdd.stream());
            }
            progress.progress(this.counter.get(), "Processed " + this.counter + " input terms.");
            progress.setResultUrl(this.menuReaderService.getMenu().findMenuItemPath("sorta") + "/result/" + resultRepositoryName);
        });
        return null;
    }
}

