/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.controller;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.file.FileStore;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.jobs.JobExecutor;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.ontology.core.meta.OntologyTermMetadata;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.ontology.sorta.controller.EntityCollectionResponse;
import org.molgenis.ontology.sorta.controller.EntityPager;
import org.molgenis.ontology.sorta.job.SortaJobExecution;
import org.molgenis.ontology.sorta.job.SortaJobExecutionFactory;
import org.molgenis.ontology.sorta.meta.MatchingTaskContentMetaData;
import org.molgenis.ontology.sorta.meta.SortaJobExecutionMetadata;
import org.molgenis.ontology.sorta.repo.SortaCsvRepository;
import org.molgenis.ontology.sorta.request.SortaServiceRequest;
import org.molgenis.ontology.sorta.request.SortaServiceResponse;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;
import org.molgenis.ontology.utils.SortaServiceUtil;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugin/sorta"})
public class SortaController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(SortaController.class);
    public static final String ID = "sorta";
    public static final String URI = "/plugin/sorta";
    private static final int BATCH_SIZE = 1000;
    private static final String MODEL_KEY_MESSAGE = "message";
    public static final String MATCH_VIEW_NAME = "sorta-match-view";
    public static final double DEFAULT_THRESHOLD = 100.0;
    private final OntologyService ontologyService;
    private final SortaService sortaService;
    private final DataService dataService;
    private final UserAccountService userAccountService;
    private final FileStore fileStore;
    private final UserPermissionEvaluator permissionService;
    private final MenuReaderService menuReaderService;
    private final IdGenerator idGenerator;
    private final PermissionSystemService permissionSystemService;
    private final MatchingTaskContentMetaData matchingTaskContentMetaData;
    private final SortaJobExecutionMetadata sortaJobExecutionMetaData;
    private final OntologyTermMetadata ontologyTermMetadata;
    private final SortaJobExecutionFactory sortaJobExecutionFactory;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    private final JobExecutor jobExecutor;

    public SortaController(OntologyService ontologyService, SortaService sortaService, UserAccountService userAccountService, FileStore fileStore, UserPermissionEvaluator permissionService, DataService dataService, MenuReaderService menuReaderService, IdGenerator idGenerator, PermissionSystemService permissionSystemService, MatchingTaskContentMetaData matchingTaskContentMetaData, SortaJobExecutionMetadata sortaJobExecutionMetaData, OntologyTermMetadata ontologyTermMetadata, SortaJobExecutionFactory sortaJobExecutionFactory, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, JobExecutor jobExecutor) {
        super(URI);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.sortaService = Objects.requireNonNull(sortaService);
        this.userAccountService = Objects.requireNonNull(userAccountService);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.permissionService = Objects.requireNonNull(permissionService);
        this.dataService = Objects.requireNonNull(dataService);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.permissionSystemService = Objects.requireNonNull(permissionSystemService);
        this.matchingTaskContentMetaData = Objects.requireNonNull(matchingTaskContentMetaData);
        this.sortaJobExecutionMetaData = Objects.requireNonNull(sortaJobExecutionMetaData);
        this.ontologyTermMetadata = Objects.requireNonNull(ontologyTermMetadata);
        this.sortaJobExecutionFactory = Objects.requireNonNull(sortaJobExecutionFactory);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.jobExecutor = jobExecutor;
    }

    @GetMapping
    public String init(Model model) {
        model.addAttribute("existingTasks", this.getJobsForCurrentUser());
        return MATCH_VIEW_NAME;
    }

    private SortaJobExecution findSortaJobExecution(String sortaJobExecutionId) {
        Fetch fetch = new Fetch();
        this.sortaJobExecutionMetaData.getAtomicAttributes().forEach(attr -> fetch.field(attr.getName()));
        return (SortaJobExecution)((Object)RunAsSystemAspect.runAsSystem(() -> (SortaJobExecution)this.dataService.findOneById("sys_job_SortaJobExecution", (Object)sortaJobExecutionId, fetch, SortaJobExecution.class)));
    }

    @GetMapping(value={"/jobs"})
    @ResponseBody
    public List<SortaJobExecution> getJobs() {
        return this.getJobsForCurrentUser();
    }

    @GetMapping(value={"/newtask"})
    public String matchTask(Model model) {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return MATCH_VIEW_NAME;
    }

    @PostMapping(value={"/threshold/{sortaJobExecutionId}"})
    public String updateThreshold(@RequestParam(value="threshold") String threshold, @PathVariable String sortaJobExecutionId, Model model) {
        if (!StringUtils.isEmpty((CharSequence)threshold)) {
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            try {
                User currentUser = this.userAccountService.getCurrentUser();
                if (currentUser.isSuperuser().booleanValue() || com.google.common.base.Objects.equal(sortaJobExecution.getUser().orElse(null), (Object)currentUser.getUsername())) {
                    RunAsSystemAspect.runAsSystem(() -> {
                        Double thresholdValue = Double.parseDouble(threshold);
                        sortaJobExecution.setThreshold(thresholdValue);
                        this.dataService.update("sys_job_SortaJobExecution", (Entity)sortaJobExecution);
                    });
                }
            }
            catch (NumberFormatException e) {
                model.addAttribute(MODEL_KEY_MESSAGE, (Object)(threshold + " is illegal threshold value!"));
            }
            catch (Exception other) {
                model.addAttribute(MODEL_KEY_MESSAGE, (Object)("Error updating threshold: " + other.getMessage()));
            }
        }
        return this.matchResult(sortaJobExecutionId, model);
    }

    @GetMapping(value={"/result/{sortaJobExecutionId}"})
    public String matchResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId, Model model) {
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        if (sortaJobExecution != null) {
            model.addAttribute("sortaJobExecutionId", (Object)sortaJobExecution.getIdentifier());
            model.addAttribute("threshold", (Object)sortaJobExecution.getThreshold());
            model.addAttribute("ontologyIri", (Object)sortaJobExecution.getOntologyIri());
            model.addAttribute("numberOfMatched", (Object)this.countMatchedEntities(sortaJobExecution, true));
            model.addAttribute("numberOfUnmatched", (Object)this.countMatchedEntities(sortaJobExecution, false));
            return MATCH_VIEW_NAME;
        }
        LOG.info("Job execution with id {} not found.", (Object)sortaJobExecutionId);
        model.addAttribute(MODEL_KEY_MESSAGE, (Object)"Job execution not found.");
        return this.init(model);
    }

    @GetMapping(value={"/count/{sortaJobExecutionId}"})
    @ResponseBody
    public Map<String, Object> countMatchResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId) {
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        return ImmutableMap.of((Object)"numberOfMatched", (Object)this.countMatchedEntities(sortaJobExecution, true), (Object)"numberOfUnmatched", (Object)this.countMatchedEntities(sortaJobExecution, false));
    }

    @PostMapping(value={"/delete/{sortaJobExecutionId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId, Model model) {
        User currentUser;
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        if (sortaJobExecution != null && ((currentUser = this.userAccountService.getCurrentUser()).isSuperuser().booleanValue() || com.google.common.base.Objects.equal(sortaJobExecution.getUser().orElse(null), (Object)currentUser.getUsername()))) {
            RunAsSystemAspect.runAsSystem(() -> this.dataService.deleteById("sys_job_SortaJobExecution", (Object)sortaJobExecution.getIdentifier()));
            this.tryDeleteRepository(sortaJobExecution.getResultEntityName());
            this.tryDeleteRepository(sortaJobExecution.getSourceEntityName());
        }
        return this.init(model);
    }

    private void tryDeleteRepository(String entityTypeId) {
        if (this.dataService.hasRepository(entityTypeId) && this.permissionService.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityTypeId), (Permission)EntityTypePermission.DELETE_METADATA)) {
            RunAsSystemAspect.runAsSystem(() -> this.deleteRepository(entityTypeId));
        } else {
            LOG.info("Unable to delete repository {}", (Object)entityTypeId);
        }
    }

    private void deleteRepository(String entityTypeId) {
        try {
            this.dataService.getMeta().deleteEntityType(entityTypeId);
            LOG.info("Deleted repository {}", (Object)entityTypeId);
        }
        catch (Exception ex) {
            LOG.error("Failed to delete existing writable repository {}", (Object)entityTypeId);
        }
    }

    @PostMapping(value={"/match/retrieve"})
    @ResponseBody
    public EntityCollectionResponse retrieveSortaJobResults(@RequestBody SortaServiceRequest sortaServiceRequest) {
        ArrayList<Map<String, Object>> entityMaps = new ArrayList<Map<String, Object>>();
        String sortaJobExecutionId = sortaServiceRequest.getSortaJobExecutionId();
        String filterQuery = sortaServiceRequest.getFilterQuery();
        String ontologyIri = sortaServiceRequest.getOntologyIri();
        EntityPager entityPager = sortaServiceRequest.getEntityPager();
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        String resultEntityName = sortaJobExecution.getResultEntityName();
        double threshold = sortaJobExecution.getThreshold();
        boolean isMatched = sortaServiceRequest.isMatched();
        QueryRule queryRuleInputEntities = new QueryRule(Arrays.asList(new QueryRule("validated", QueryRule.Operator.EQUALS, (Object)isMatched), new QueryRule(isMatched ? QueryRule.Operator.OR : QueryRule.Operator.AND), new QueryRule("score", isMatched ? QueryRule.Operator.GREATER_EQUAL : QueryRule.Operator.LESS, (Object)threshold)));
        List<QueryRule> queryRuleInputEntitiesInOneMatchingTask = Collections.singletonList(queryRuleInputEntities);
        if (StringUtils.isNotEmpty((CharSequence)filterQuery)) {
            Iterable filteredInputTermIds = this.dataService.findAll(sortaJobExecution.getSourceEntityName(), new QueryImpl().search(filterQuery)).map(inputEntity -> inputEntity.getString("Identifier")).collect(Collectors.toList());
            QueryRule previousQueryRule = new QueryRule(queryRuleInputEntitiesInOneMatchingTask);
            QueryRule queryRuleFilterInput = new QueryRule("inputTerm", QueryRule.Operator.IN, (Object)filteredInputTermIds);
            queryRuleInputEntitiesInOneMatchingTask = Arrays.asList(previousQueryRule, new QueryRule(QueryRule.Operator.AND), queryRuleFilterInput);
        }
        QueryImpl query = new QueryImpl(queryRuleInputEntitiesInOneMatchingTask);
        long count = this.dataService.count(resultEntityName, (Query)query);
        int start = entityPager.getStart();
        int num = entityPager.getNum();
        Stream findAll = this.dataService.findAll(sortaJobExecution.getResultEntityName(), query.offset(start).pageSize(num).sort(new Sort().on("validated", Sort.Direction.DESC).on("score", Sort.Direction.DESC)));
        findAll.forEach(mappingEntity -> {
            HashMap<String, Map<String, Object>> outputEntity = new HashMap<String, Map<String, Object>>();
            outputEntity.put("inputTerm", SortaServiceUtil.getEntityAsMap(mappingEntity.getEntity("inputTerm")));
            outputEntity.put("matchedTerm", SortaServiceUtil.getEntityAsMap(mappingEntity));
            Object matchedTerm = mappingEntity.get("matchTerm");
            if (matchedTerm != null) {
                outputEntity.put("ontologyTerm", SortaServiceUtil.getEntityAsMap(this.sortaService.getOntologyTermEntity(matchedTerm.toString(), ontologyIri)));
            }
            entityMaps.add(outputEntity);
        });
        EntityPager pager = new EntityPager(start, num, count, null);
        return new EntityCollectionResponse(pager, entityMaps, "/match/retrieve", (EntityType)this.ontologyTermMetadata, this.permissionService, this.dataService);
    }

    @PostMapping(value={"/match"})
    public String match(@RequestParam(value="taskName") String jobName, @RequestParam(value="selectOntologies") String ontologyIri, @RequestParam(value="inputTerms") String inputTerms, Model model, HttpServletRequest httpServletRequest) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || StringUtils.isEmpty((CharSequence)inputTerms)) {
            return this.init(model);
        }
        this.validateJobName(jobName);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(inputTerms.getBytes("UTF8"));){
            String string = this.startMatchJob(jobName, ontologyIri, model, httpServletRequest, inputStream);
            return string;
        }
    }

    @PostMapping(value={"/match/upload"}, headers={"Content-Type=multipart/form-data"})
    public String upload(@RequestParam(value="taskName") String jobName, @RequestParam(value="selectOntologies") String ontologyIri, @RequestParam(value="file") MultipartFile file, Model model, HttpServletRequest httpServletRequest) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || file == null) {
            return this.init(model);
        }
        this.validateJobName(jobName);
        try (InputStream inputStream = file.getInputStream();){
            String string = this.startMatchJob(jobName, ontologyIri, model, httpServletRequest, inputStream);
            return string;
        }
    }

    @PostMapping(value={"/match/entity"})
    @ResponseBody
    public SortaServiceResponse findMatchingOntologyTerms(@RequestBody Map<String, Object> request) {
        if (request.containsKey("sortaJobExecutionId") && !StringUtils.isEmpty((CharSequence)request.get("sortaJobExecutionId").toString()) && request.containsKey("identifier") && !StringUtils.isEmpty((CharSequence)request.get("identifier").toString())) {
            String sortaJobExecutionId = request.get("sortaJobExecutionId").toString();
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            if (sortaJobExecution == null) {
                return new SortaServiceResponse("sortaJobExecutionId is invalid!");
            }
            String inputTermIdentifier = request.get("identifier").toString();
            Entity inputEntity = this.dataService.findOneById(sortaJobExecution.getSourceEntityName(), (Object)inputTermIdentifier);
            if (inputEntity == null) {
                return new SortaServiceResponse("inputTerm identifier is invalid!");
            }
            return new SortaServiceResponse(inputEntity, this.sortaService.findOntologyTermEntities(sortaJobExecution.getOntologyIri(), inputEntity));
        }
        return new SortaServiceResponse("Please check that sortaJobExecutionId and identifier keys exist in input and have nonempty value!");
    }

    private Entity toDownloadRow(SortaJobExecution sortaJobExecution, Entity resultEntity, EntityType downloadEntityType) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        Entity inputEntity = resultEntity.getEntity("inputTerm");
        Entity ontologyTermEntity = this.sortaService.getOntologyTermEntity(resultEntity.getString("matchTerm"), sortaJobExecution.getOntologyIri());
        DynamicEntity row = new DynamicEntity(downloadEntityType);
        inputEntity.getAttributeNames().forEach(arg_0 -> SortaController.lambda$toDownloadRow$7((Entity)row, inputEntity, arg_0));
        if (ontologyTermEntity != null) {
            row.set("ontologyTermName", (Object)ontologyTermEntity.getString("ontologyTermName"));
            row.set("ontologyTermIRI", (Object)ontologyTermEntity.getString("ontologyTermIRI"));
        }
        row.set("validated", (Object)resultEntity.getBoolean("validated"));
        Double score = resultEntity.getDouble("score");
        if (score != null) {
            row.set("score", (Object)format.format(score));
        }
        return row;
    }

    @GetMapping(value={"/match/download/{sortaJobExecutionId}"})
    public void download(@PathVariable String sortaJobExecutionId, HttpServletResponse response) throws IOException {
        try (CsvWriter csvWriter = new CsvWriter((OutputStream)response.getOutputStream(), SortaServiceImpl.DEFAULT_SEPARATOR.charValue());){
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            response.setContentType("text/csv");
            response.addHeader("Content-Disposition", "attachment; filename=" + this.generateCsvFileName());
            ArrayList<String> columnHeaders = new ArrayList<String>();
            EntityType targetMetadata = (EntityType)this.entityTypeFactory.create((Object)("SortaDownload" + sortaJobExecutionId));
            EntityType sourceMetaData = this.dataService.getEntityType(sortaJobExecution.getSourceEntityName());
            for (Attribute attribute : sourceMetaData.getAttributes()) {
                if (attribute.getName().equalsIgnoreCase("Identifier")) continue;
                columnHeaders.add(attribute.getName());
                targetMetadata.addAttribute(this.attrMetaFactory.create().setName(attribute.getName()), new EntityType.AttributeRole[0]);
            }
            columnHeaders.addAll(Arrays.asList("ontologyTermName", "ontologyTermIRI", "score", "validated"));
            targetMetadata.addAttribute(this.ontologyTermMetadata.getAttribute("ontologyTermName"), new EntityType.AttributeRole[0]);
            targetMetadata.addAttribute(this.ontologyTermMetadata.getAttribute("ontologyTermIRI"), new EntityType.AttributeRole[0]);
            targetMetadata.addAttribute(Attribute.newInstance((Attribute)this.matchingTaskContentMetaData.getAttribute("score"), (EntityType.AttributeCopyMode)EntityType.AttributeCopyMode.SHALLOW_COPY_ATTRS, (AttributeFactory)this.attrMetaFactory).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
            targetMetadata.addAttribute(this.matchingTaskContentMetaData.getAttribute("validated"), new EntityType.AttributeRole[0]);
            csvWriter.writeAttributeNames(columnHeaders);
            this.dataService.findAll(sortaJobExecution.getResultEntityName(), (Query)new QueryImpl()).forEach(resultEntity -> csvWriter.add(this.toDownloadRow(sortaJobExecution, (Entity)resultEntity, targetMetadata)));
        }
    }

    private String startMatchJob(String jobName, String ontologyIri, Model model, HttpServletRequest httpServletRequest, InputStream inputStream) throws IOException {
        String sessionId = httpServletRequest.getSession().getId();
        File uploadFile = this.fileStore.store(inputStream, sessionId + ".csv");
        String inputRepositoryName = this.idGenerator.generateId();
        SortaCsvRepository inputRepository = new SortaCsvRepository(inputRepositoryName, jobName + " input", uploadFile, this.entityTypeFactory, this.attrMetaFactory);
        if (!this.validateFileHeader((Repository<Entity>)inputRepository)) {
            model.addAttribute(MODEL_KEY_MESSAGE, (Object)"The Name header is missing!");
            return this.matchTask(model);
        }
        if (!this.validateEmptyFileHeader((Repository<Entity>)inputRepository)) {
            model.addAttribute(MODEL_KEY_MESSAGE, (Object)"The empty header is not allowed!");
            return this.matchTask(model);
        }
        if (!this.validateInputFileContent((Repository<Entity>)inputRepository)) {
            model.addAttribute(MODEL_KEY_MESSAGE, (Object)"The content of input is empty!");
            return this.matchTask(model);
        }
        SortaJobExecution sortaJobExecution = this.createJobExecution((Repository<Entity>)inputRepository, jobName, ontologyIri);
        this.jobExecutor.submit((JobExecution)sortaJobExecution);
        return "redirect:" + this.getSortaServiceMenuUrl();
    }

    private List<SortaJobExecution> getJobsForCurrentUser() {
        User currentUser = this.userAccountService.getCurrentUser();
        Query query = this.dataService.query("sys_job_SortaJobExecution", SortaJobExecution.class).eq("user", (Object)currentUser.getUsername());
        query.sort().on("startDate", Sort.Direction.DESC);
        return (List)RunAsSystemAspect.runAsSystem(() -> query.findAll().collect(Collectors.toList()));
    }

    private SortaJobExecution createJobExecution(Repository<Entity> inputData, String jobName, String ontologyIri) {
        String resultEntityName = this.idGenerator.generateId();
        SortaJobExecution sortaJobExecution = (SortaJobExecution)this.sortaJobExecutionFactory.create();
        sortaJobExecution.setIdentifier(resultEntityName);
        sortaJobExecution.setName(jobName);
        User currentUser = this.userAccountService.getCurrentUser();
        sortaJobExecution.setSourceEntityName(inputData.getName());
        sortaJobExecution.setDeleteUrl(this.getSortaServiceMenuUrl() + "/delete/" + resultEntityName);
        sortaJobExecution.setResultEntityName(resultEntityName);
        sortaJobExecution.setThreshold(100.0);
        sortaJobExecution.setOntologyIri(ontologyIri);
        RunAsSystemAspect.runAsSystem(() -> {
            this.createInputRepository(inputData);
            this.createEmptyResultRepository(jobName, resultEntityName, inputData.getEntityType());
        });
        EntityType resultEntityType = (EntityType)this.entityTypeFactory.create((Object)resultEntityName);
        this.permissionSystemService.giveUserWriteMetaPermissions(Arrays.asList(inputData.getEntityType(), resultEntityType));
        return sortaJobExecution;
    }

    private void createEmptyResultRepository(String jobName, String resultEntityName, EntityType sourceMetaData) {
        EntityType resultEntityType = EntityType.newInstance((EntityType)this.matchingTaskContentMetaData, (EntityType.AttributeCopyMode)EntityType.AttributeCopyMode.DEEP_COPY_ATTRS, (AttributeFactory)this.attrMetaFactory);
        resultEntityType.setId(resultEntityName);
        resultEntityType.setPackage(null);
        resultEntityType.setAbstract(false);
        resultEntityType.addAttribute(this.attrMetaFactory.create().setName("inputTerm").setDataType(AttributeType.XREF).setRefEntity(sourceMetaData).setDescription("Reference to the input term").setNillable(false), new EntityType.AttributeRole[0]);
        resultEntityType.setLabel(jobName + " output");
        this.dataService.getMeta().addEntityType(resultEntityType);
    }

    private void createInputRepository(Repository<Entity> inputRepository) {
        this.dataService.getMeta().addEntityType(inputRepository.getEntityType());
        Repository target = this.dataService.getRepository(inputRepository.getName());
        inputRepository.forEachBatched(entities -> target.add(entities.stream()), 1000);
    }

    private long countMatchedEntities(SortaJobExecution sortaJobExecution, boolean isMatched) {
        double threshold = sortaJobExecution.getThreshold();
        QueryRule validatedRule = new QueryRule("validated", QueryRule.Operator.EQUALS, (Object)isMatched);
        QueryRule thresholdRule = new QueryRule("score", isMatched ? QueryRule.Operator.GREATER_EQUAL : QueryRule.Operator.LESS, (Object)threshold);
        QueryRule combinedRule = new QueryRule(Arrays.asList(validatedRule, new QueryRule(isMatched ? QueryRule.Operator.OR : QueryRule.Operator.AND), thresholdRule));
        return this.dataService.count(sortaJobExecution.getResultEntityName(), (Query)new QueryImpl(combinedRule));
    }

    private String generateCsvFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "match-result_" + dateFormat.format(new Date()) + ".csv";
    }

    private boolean validateFileHeader(Repository<Entity> repository) {
        return Streams.stream((Iterable)repository.getEntityType().getAttributes()).map(Attribute::getName).anyMatch(name -> name.equalsIgnoreCase("Name"));
    }

    private boolean validateEmptyFileHeader(Repository<Entity> repository) {
        return Streams.stream((Iterable)repository.getEntityType().getAttributes()).map(Attribute::getName).anyMatch(StringUtils::isNotBlank);
    }

    private boolean validateInputFileContent(Repository<Entity> repository) {
        return repository.iterator().hasNext();
    }

    private String getSortaServiceMenuUrl() {
        return this.menuReaderService.findMenuItemPath(ID);
    }

    private void validateJobName(String jobName) {
        if (!jobName.matches("\\w+")) {
            throw new IllegalArgumentException("Job name contains characters other than [a-zA-Z_0-9]");
        }
    }

    private static /* synthetic */ void lambda$toDownloadRow$7(Entity row, Entity inputEntity, String attributeName) {
        if (!attributeName.equalsIgnoreCase("Identifier")) {
            row.set(attributeName, inputEntity.get(attributeName));
        }
    }
}

