/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology;

import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.ontology.core.ic.OntologyTermFrequencyServiceImpl;
import org.molgenis.ontology.core.meta.OntologyTermSynonymFactory;
import org.molgenis.ontology.roc.InformationContentService;
import org.molgenis.ontology.sorta.meta.OntologyTermHitMetaData;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={OntologyTermFrequencyServiceImpl.class})
@Configuration
public class SortaConfig {
    private final DataService dataService;
    private final OntologyTermHitMetaData ontologyTermHitMetaData;
    private final OntologyTermSynonymFactory ontologyTermSynonymFactory;

    public SortaConfig(DataService dataService, OntologyTermHitMetaData ontologyTermHitMetaData, OntologyTermSynonymFactory ontologyTermSynonymFactory) {
        System.setProperty("jdk.xml.entityExpansionLimit", "1280000");
        this.dataService = Objects.requireNonNull(dataService);
        this.ontologyTermHitMetaData = Objects.requireNonNull(ontologyTermHitMetaData);
        this.ontologyTermSynonymFactory = Objects.requireNonNull(ontologyTermSynonymFactory);
    }

    @Bean
    public SortaService sortaService() {
        return new SortaServiceImpl(this.dataService, this.informationContentService(), this.ontologyTermHitMetaData, this.ontologyTermSynonymFactory);
    }

    @Bean
    public InformationContentService informationContentService() {
        return new InformationContentService(this.dataService);
    }
}

