/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.controller;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.DataService;
import org.molgenis.data.Range;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.ontology.sorta.controller.EntityTypeResponse;
import org.molgenis.ontology.sorta.controller.Href;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.util.i18n.LanguageService;

public class AttributeResponse {
    private static final String BASE_URI = "/api/v1";
    private final String href;
    private final AttributeType fieldType;
    private final String name;
    private final String label;
    private final String description;
    private final List<?> attributes;
    private final List<String> enumOptions;
    private final Long maxLength;
    private final Object refEntity;
    private final String mappedBy;
    private final Boolean auto;
    private final Boolean nillable;
    private final Boolean readOnly;
    private final Object defaultValue;
    private final Boolean labelAttribute;
    private final Boolean unique;
    private final Boolean visible;
    private Boolean lookupAttribute;
    private Boolean isAggregatable;
    private Range range;
    private String expression;
    private String nullableExpression;
    private String visibleExpression;
    private String validationExpression;

    public AttributeResponse(String entityParentName, EntityType entityType, Attribute attr, UserPermissionEvaluator permissionService, DataService dataService) {
        this(entityParentName, entityType, attr, null, null, permissionService, dataService);
    }

    public AttributeResponse(String entityParentName, EntityType entityType, Attribute attr, Set<String> attributesSet, Map<String, Set<String>> attributeExpandsSet, UserPermissionEvaluator permissionService, DataService dataService) {
        Iterable attributeParts;
        String attrName = attr.getName();
        this.href = Href.concatMetaAttributeHref(BASE_URI, entityParentName, attrName);
        this.fieldType = attributesSet == null || attributesSet.contains("fieldType".toLowerCase()) ? attr.getDataType() : null;
        this.name = attributesSet == null || attributesSet.contains("name".toLowerCase()) ? attrName : null;
        this.label = attributesSet == null || attributesSet.contains("label".toLowerCase()) ? attr.getLabel(LanguageService.getCurrentUserLanguageCode()) : null;
        this.description = attributesSet == null || attributesSet.contains("description".toLowerCase()) ? attr.getDescription(LanguageService.getCurrentUserLanguageCode()) : null;
        this.enumOptions = attributesSet == null || attributesSet.contains("enumOptions".toLowerCase()) ? attr.getEnumOptions() : null;
        this.maxLength = attributesSet == null || attributesSet.contains("maxLength".toLowerCase()) ? attr.getDataType().getMaxLength() : null;
        this.expression = attributesSet == null || attributesSet.contains("expression".toLowerCase()) ? attr.getExpression() : null;
        if (attributesSet == null || attributesSet.contains("refEntity".toLowerCase())) {
            if (attributeExpandsSet != null && attributeExpandsSet.containsKey("refEntity".toLowerCase())) {
                Set<String> subAttributesSet = attributeExpandsSet.get("refEntity".toLowerCase());
                this.refEntity = attr.hasRefEntity() ? new EntityTypeResponse(attr.getRefEntity(), subAttributesSet, Collections.singletonMap("attributes".toLowerCase(), null), permissionService, dataService) : null;
            } else {
                this.refEntity = attr.hasRefEntity() ? new Href(Href.concatMetaEntityHref(BASE_URI, attr.getRefEntity().getId()), String.format("%s/%s", BASE_URI, attr.getRefEntity().getId())) : null;
            }
        } else {
            this.refEntity = null;
        }
        Attribute mappedByAttr = attr.getMappedBy();
        String string = this.mappedBy = mappedByAttr != null ? mappedByAttr.getName() : null;
        this.attributes = attributesSet == null || attributesSet.contains("attributes".toLowerCase()) ? ((attributeParts = attr.getChildren()) != null ? Lists.newArrayList((Iterable)Iterables.transform((Iterable)attributeParts, attribute -> {
            if (attributeExpandsSet != null && attributeExpandsSet.containsKey("attributes".toLowerCase())) {
                Set subAttributesSet = (Set)attributeExpandsSet.get("attributes".toLowerCase());
                return new AttributeResponse(entityParentName, entityType, (Attribute)attribute, subAttributesSet, (Map<String, Set<String>>)Collections.singletonMap("refEntity".toLowerCase(), null), permissionService, dataService);
            }
            return Collections.singletonMap("href", Href.concatMetaAttributeHref(BASE_URI, entityParentName, attribute.getName()));
        })) : null) : null;
        this.auto = attributesSet == null || attributesSet.contains("auto".toLowerCase()) ? Boolean.valueOf(attr.isAuto()) : null;
        this.nillable = attributesSet == null || attributesSet.contains("nillable".toLowerCase()) ? Boolean.valueOf(attr.isNillable()) : null;
        this.readOnly = attributesSet == null || attributesSet.contains("readOnly".toLowerCase()) ? Boolean.valueOf(attr.isReadOnly()) : null;
        this.defaultValue = attributesSet == null || attributesSet.contains("defaultValue".toLowerCase()) ? attr.getDefaultValue() : null;
        this.labelAttribute = attributesSet == null || attributesSet.contains("labelAttribute".toLowerCase()) ? Boolean.valueOf(attr.equals(entityType.getLabelAttribute())) : null;
        this.unique = attributesSet == null || attributesSet.contains("unique".toLowerCase()) ? Boolean.valueOf(attr.isUnique()) : null;
        this.lookupAttribute = attributesSet == null || attributesSet.contains("lookupAttribute".toLowerCase()) ? Boolean.valueOf(entityType.getLookupAttribute(attr.getName()) != null) : null;
        this.isAggregatable = attributesSet == null || attributesSet.contains("isAggregatable".toLowerCase()) ? Boolean.valueOf(attr.isAggregatable()) : null;
        this.range = attributesSet == null || attributesSet.contains("range".toLowerCase()) ? attr.getRange() : null;
        this.visible = attributesSet == null || attributesSet.contains("isVisible".toLowerCase()) ? Boolean.valueOf(attr.isVisible()) : null;
        this.nullableExpression = attributesSet == null || attributesSet.contains("nullableExpression".toLowerCase()) ? attr.getNullableExpression() : null;
        this.visibleExpression = attributesSet == null || attributesSet.contains("visibleExpression".toLowerCase()) ? attr.getVisibleExpression() : null;
        this.validationExpression = attributesSet == null || attributesSet.contains("validationExpression".toLowerCase()) ? attr.getValidationExpression() : null;
    }

    public String getHref() {
        return this.href;
    }

    public AttributeType getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<?> getAttributes() {
        return this.attributes;
    }

    public List<String> getEnumOptions() {
        return this.enumOptions;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Object getRefEntity() {
        return this.refEntity;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isLabelAttribute() {
        return this.labelAttribute;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Boolean getLookupAttribute() {
        return this.lookupAttribute;
    }

    public Boolean isAggregatable() {
        return this.isAggregatable;
    }

    public Range getRange() {
        return this.range;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getNullableExpression() {
        return this.nullableExpression;
    }

    public String getVisibleExpression() {
        return this.visibleExpression;
    }

    public String getValidationExpression() {
        return this.validationExpression;
    }
}

