/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.controller;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.DataService;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.ontology.sorta.controller.AttributeResponse;
import org.molgenis.ontology.sorta.controller.Href;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.util.i18n.LanguageService;
import org.springframework.security.acls.model.ObjectIdentity;

public class EntityTypeResponse {
    private static final String BASE_URI = "/api/v1";
    private final String href;
    private final String hrefCollection;
    private final String name;
    private final String label;
    private final String description;
    private final Map<String, Object> attributes;
    private final String labelAttribute;
    private final String idAttribute;
    private final List<String> lookupAttributes;
    private final Boolean isAbstract;
    private String languageCode;
    private final Set<Permission> permissions;
    private final Boolean writable;

    public EntityTypeResponse(EntityType meta, UserPermissionEvaluator userPermissionEvaluator, DataService dataService) {
        this(meta, null, null, userPermissionEvaluator, dataService);
    }

    public EntityTypeResponse(EntityType meta, Set<String> attributesSet, Map<String, Set<String>> attributeExpandsSet, UserPermissionEvaluator userPermissionEvaluator, DataService dataService) {
        Iterable metaLookupAttributes;
        Attribute metaIdAttribute;
        Attribute metaLabelAttribute;
        String metaId = meta.getId();
        this.href = Href.concatMetaEntityHref(BASE_URI, metaId);
        this.hrefCollection = String.format("%s/%s", BASE_URI, metaId);
        this.languageCode = LanguageService.getCurrentUserLanguageCode();
        this.name = attributesSet == null || attributesSet.contains("name".toLowerCase()) ? metaId : null;
        this.description = attributesSet == null || attributesSet.contains("description".toLowerCase()) ? meta.getDescription(LanguageService.getCurrentUserLanguageCode()) : null;
        this.label = attributesSet == null || attributesSet.contains("label".toLowerCase()) ? meta.getLabel(LanguageService.getCurrentUserLanguageCode()) : null;
        if (attributesSet == null || attributesSet.contains("attributes".toLowerCase())) {
            this.attributes = new LinkedHashMap<String, Object>();
            for (Attribute attr : Lists.newArrayList((Iterable)meta.getAttributes())) {
                if (attr.getName().equals("__Type")) continue;
                if (attributeExpandsSet != null && attributeExpandsSet.containsKey("attributes".toLowerCase())) {
                    Set<String> subAttributesSet = attributeExpandsSet.get("attributes".toLowerCase());
                    this.attributes.put(attr.getName(), new AttributeResponse(metaId, meta, attr, subAttributesSet, Collections.singletonMap("refEntity".toLowerCase(), Sets.newHashSet((Object[])new String[]{"idattribute"})), userPermissionEvaluator, dataService));
                    continue;
                }
                String attrHref = Href.concatMetaAttributeHref(BASE_URI, metaId, attr.getName());
                this.attributes.put(attr.getName(), Collections.singletonMap("href", attrHref));
            }
        } else {
            this.attributes = null;
        }
        this.labelAttribute = attributesSet == null || attributesSet.contains("labelAttribute".toLowerCase()) ? ((metaLabelAttribute = meta.getLabelAttribute(this.languageCode)) != null ? metaLabelAttribute.getName() : null) : null;
        this.idAttribute = attributesSet == null || attributesSet.contains("idAttribute".toLowerCase()) ? ((metaIdAttribute = meta.getIdAttribute()) != null ? metaIdAttribute.getName() : null) : null;
        this.lookupAttributes = attributesSet == null || attributesSet.contains("lookupAttributes".toLowerCase()) ? ((metaLookupAttributes = meta.getLookupAttributes()) != null ? Lists.newArrayList((Iterable)Iterables.transform((Iterable)metaLookupAttributes, Attribute::getName)) : null) : null;
        this.isAbstract = attributesSet == null || attributesSet.contains("abstract".toLowerCase()) ? Boolean.valueOf(meta.isAbstract()) : null;
        boolean hasWritePermission = userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(metaId), (Permission)EntityTypePermission.UPDATE_DATA);
        boolean hasWriteMetaPermission = userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(metaId), (Permission)EntityTypePermission.UPDATE_METADATA);
        this.writable = (hasWritePermission || hasWriteMetaPermission) && dataService.getCapabilities(metaId).contains(RepositoryCapability.WRITABLE);
        this.permissions = userPermissionEvaluator.getPermissions((ObjectIdentity)new EntityTypeIdentity(metaId), (Permission[])EntityTypePermission.values());
    }

    public String getHref() {
        return this.href;
    }

    public String getHrefCollection() {
        return this.hrefCollection;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public List<String> getLookupAttributes() {
        return this.lookupAttributes;
    }

    public Map<String, Object> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    public String getLabelAttribute() {
        return this.labelAttribute;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Boolean getWritable() {
        return this.writable;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }
}

