/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.controller;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.molgenis.data.DataConverter;
import org.molgenis.data.Entity;
import org.springframework.web.util.UriUtils;

public class Href {
    private final String href;
    private final String hrefCollection;

    public Href(String href, String hrefCollection) {
        this.href = href;
        this.hrefCollection = hrefCollection;
    }

    public String getHref() {
        return this.href;
    }

    public String getHrefCollection() {
        return this.hrefCollection;
    }

    public static String concatAttributeHref(String baseUri, String qualifiedEntityName, Object entityIdValue, String attributeName) {
        return String.format("%s/%s/%s/%s", baseUri, Href.encodePathSegment(qualifiedEntityName), Href.encodePathSegment(DataConverter.toString((Object)entityIdValue)), Href.encodePathSegment(attributeName));
    }

    public static String concatMetaAttributeHref(String baseUri, String entityParentName, String attributeName) {
        return String.format("%s/%s/meta/%s", baseUri, Href.encodePathSegment(entityParentName), Href.encodePathSegment(attributeName));
    }

    public static String concatEntityHref(Entity entity) {
        return Href.concatEntityHref("/api/v2", entity.getEntityType().getId(), entity.getIdValue());
    }

    public static String concatEntityHref(String baseUri, String qualifiedEntityName, Object entityIdValue) {
        if (null == qualifiedEntityName) {
            qualifiedEntityName = "";
        }
        return String.format("%s/%s/%s", baseUri, Href.encodePathSegment(qualifiedEntityName), Href.encodePathSegment(DataConverter.toString((Object)entityIdValue)));
    }

    public static String concatMetaEntityHref(String baseUri, String qualifiedEntityName) {
        return String.format("%s/%s/meta", baseUri, Href.encodePathSegment(qualifiedEntityName));
    }

    public static String concatMetaEntityHrefV2(String baseUri, String qualifiedEntityName) {
        return String.format("%s/%s", baseUri, Href.encodePathSegment(qualifiedEntityName));
    }

    public static String concatEntityCollectionHref(String baseUri, String qualifiedEntityName, String qualifiedIdAttributeName, List<String> entitiesIds) {
        String ids = entitiesIds.stream().map(Href::encodeIdToRSQL).collect(Collectors.joining(","));
        return String.format("%s/%s?q=%s=in=(%s)", baseUri, Href.encodePathSegment(qualifiedEntityName), Href.encodePathSegment(qualifiedIdAttributeName), ids);
    }

    private static String encodeIdToRSQL(String id) {
        return "\"" + Href.encodePathSegment(id) + "\"";
    }

    private static String encodePathSegment(String pathSegment) {
        return UriUtils.encodePathSegment((String)pathSegment, (String)StandardCharsets.UTF_8.name());
    }
}

