/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.pathways.service;

import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.molgenis.pathways.model.Impact;
import org.molgenis.pathways.model.Pathway;
import org.molgenis.pathways.service.CacheFactory;
import org.molgenis.pathways.service.ColoredPathwayParameters;
import org.molgenis.pathways.service.PathwaysPerGeneParameters;
import org.molgenis.wikipathways.client.WikiPathwaysPortType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WikiPathwaysService {
    private static final String[] HGNC_CODE = new String[]{"H"};
    private final WikiPathwaysPortType wikiPathwaysProxy;
    private final LoadingCache<String, Set<Pathway>> allPathwaysCache;
    private final LoadingCache<PathwaysPerGeneParameters, Set<Pathway>> pathwaysPerGeneCache;
    private final LoadingCache<ColoredPathwayParameters, String> coloredPathwayImageCache;
    private final LoadingCache<String, String> uncoloredPathwayImageCache;

    @Autowired
    public WikiPathwaysService(WikiPathwaysPortType wikiPathwaysProxy) {
        this.wikiPathwaysProxy = wikiPathwaysProxy;
        this.allPathwaysCache = CacheFactory.loadingPathwayCache(wikiPathwaysProxy::listPathways, (organism, pathway) -> true, Pathway::create);
        this.pathwaysPerGeneCache = CacheFactory.loadingPathwayCache(params -> wikiPathwaysProxy.findPathwaysByXref(params.getGeneArray(), HGNC_CODE), (params, pathway) -> pathway.getSpecies().equals(params.getSpecies()), Pathway::create);
        this.uncoloredPathwayImageCache = CacheFactory.loadingCache(pathwayId -> WikiPathwaysService.toSingleLineString(wikiPathwaysProxy.getPathwayAs("svg", (String)pathwayId, 0)));
        this.coloredPathwayImageCache = CacheFactory.loadingCache(params -> WikiPathwaysService.toSingleLineString(wikiPathwaysProxy.getColoredPathway(params.getPathwayId(), "0", params.getGraphIdArray(), params.getColorArray(), "svg")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toSingleLineString(byte[] source) {
        StringBuilder result = new StringBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(source);
        Scanner scanner = new Scanner((InputStream)bis, "UTF-8");
        scanner.useDelimiter("\\n");
        try {
            while (scanner.hasNext()) {
                result.append(scanner.next());
                result.append(" ");
            }
        }
        finally {
            scanner.close();
        }
        return result.toString();
    }

    public Collection<Pathway> getFilteredPathways(String searchTerm, String species) throws RemoteException {
        return Arrays.stream(this.wikiPathwaysProxy.findPathwaysByText(searchTerm, species)).map(Pathway::create).collect(Collectors.toList());
    }

    public String getPathwayGPML(String pathwayId) throws RemoteException {
        return this.wikiPathwaysProxy.getPathway(pathwayId, 0).getGpml();
    }

    public String getColoredPathwayImage(String pathwayId, Map<String, Impact> impactPerGraphId) throws ExecutionException {
        return (String)this.coloredPathwayImageCache.get((Object)ColoredPathwayParameters.create(pathwayId, impactPerGraphId));
    }

    public String getUncoloredPathwayImage(String pathwayId) throws ExecutionException {
        return (String)this.uncoloredPathwayImageCache.get((Object)pathwayId);
    }

    public Collection<Pathway> getPathwaysForGene(String gene, String species) throws ExecutionException {
        return (Collection)this.pathwaysPerGeneCache.get((Object)PathwaysPerGeneParameters.create(species, gene));
    }

    public Collection<Pathway> getAllPathways(String species) throws ExecutionException {
        return (Collection)this.allPathwaysCache.get((Object)species);
    }
}

