/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.pathways.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.molgenis.pathways.model.Pathway;
import org.molgenis.pathways.service.RemoteFunction;

public class CacheFactory {
    public static <K, V> LoadingCache<K, V> loadingCache(final RemoteFunction<K, V> loader) {
        return CacheBuilder.newBuilder().maximumSize(Integer.MAX_VALUE).refreshAfterWrite(1L, TimeUnit.DAYS).build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return loader.apply(key);
            }
        });
    }

    public static <Params, Result> LoadingCache<Params, Set<Pathway>> loadingPathwayCache(RemoteFunction<Params, Result[]> loader, BiPredicate<Params, Result> filter, Function<Result, Pathway> pathwayTransformer) {
        return CacheFactory.loadingCache(params -> Arrays.stream((Object[])loader.apply(params)).filter(result -> filter.test(params, result)).map(pathwayTransformer).collect(Collectors.toCollection(LinkedHashSet::new)));
    }
}

