/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.pathways;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.Valid;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.pathways.model.Impact;
import org.molgenis.pathways.model.Pathway;
import org.molgenis.pathways.service.WikiPathwaysService;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.util.stream.MultimapCollectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Controller
@RequestMapping(value={"/plugin/pathways"})
public class WikiPathwaysController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(WikiPathwaysController.class);
    private static final String ID = "pathways";
    public static final String URI = "/plugin/pathways";
    private static final Pattern EFFECT_PATTERN = Pattern.compile("([A-Z]*\\|)(\\|*[0-9]+\\||\\|+)+([0-9A-Z]+)(\\|*)(.*)");
    private static final String HOMO_SAPIENS = "Homo sapiens";
    public static final String EFFECT_ATTRIBUTE_NAME = "EFF";
    private final WikiPathwaysService wikiPathwaysService;
    @Autowired
    private DataService dataService;
    private static final Pattern GENE_SYMBOL_PATTERN = Pattern.compile("^[0-9A-Za-z\\-]*");
    private static final DocumentBuilderFactory DB_FACTORY = DocumentBuilderFactory.newInstance();

    @Autowired
    public WikiPathwaysController(WikiPathwaysService wikiPathwaysService) {
        super(URI);
        this.wikiPathwaysService = wikiPathwaysService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("entitiesMeta", this.getVCFEntities());
        return "view-pathways";
    }

    private List<EntityType> getVCFEntities() {
        return StreamSupport.stream(this.dataService.getEntityTypeIds().spliterator(), false).map(arg_0 -> ((DataService)this.dataService).getEntityType(arg_0)).filter(this::hasEffectAttribute).collect(Collectors.toList());
    }

    private boolean hasEffectAttribute(EntityType emd) {
        return emd.getAttribute(EFFECT_ATTRIBUTE_NAME) != null;
    }

    @RequestMapping(value={"/allPathways"}, method={RequestMethod.POST})
    @ResponseBody
    public Collection<Pathway> getAllPathways() throws ExecutionException {
        return this.wikiPathwaysService.getAllPathways(HOMO_SAPIENS);
    }

    @RequestMapping(value={"/filteredPathways"}, method={RequestMethod.POST})
    @ResponseBody
    public Collection<Pathway> getFilteredPathways(@RequestBody String searchTerm) throws RemoteException, ExecutionException {
        if (StringUtils.isEmpty((Object)searchTerm)) {
            return this.getAllPathways();
        }
        return this.wikiPathwaysService.getFilteredPathways(searchTerm, HOMO_SAPIENS);
    }

    @RequestMapping(value={"/pathwayViewer/{pathwayId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getPathway(@PathVariable String pathwayId) throws ExecutionException {
        return this.wikiPathwaysService.getUncoloredPathwayImage(pathwayId);
    }

    private Map<String, Impact> getGenesForVcf(String selectedVcf) {
        return StreamSupport.stream(this.dataService.getRepository(selectedVcf).spliterator(), false).map(entity -> entity.getString(EFFECT_ATTRIBUTE_NAME)).filter(eff -> !StringUtils.isEmpty((Object)WikiPathwaysController.getGeneFromEffect(eff))).collect(Collectors.groupingBy(WikiPathwaysController::getGeneFromEffect, Collectors.reducing(Impact.NONE, WikiPathwaysController::getImpactFromEffect, BinaryOperator.maxBy((i1, i2) -> i1.compareTo(i2)))));
    }

    private static Impact getImpactFromEffect(String eff) {
        return eff.contains("HIGH") ? Impact.HIGH : (eff.contains("MODERATE") ? Impact.MODERATE : (eff.contains("LOW") ? Impact.LOW : Impact.NONE));
    }

    private static String getGeneFromEffect(String eff) {
        Matcher effectMatcher;
        if (!StringUtils.isEmpty((Object)eff) && (effectMatcher = EFFECT_PATTERN.matcher(eff)).find()) {
            return effectMatcher.group(3);
        }
        return null;
    }

    @RequestMapping(value={"/pathwaysByGenes"}, method={RequestMethod.POST})
    @ResponseBody
    public Collection<Pathway> getListOfPathwayNamesByGenes(@Valid @RequestBody String selectedVcf) throws ExecutionException {
        return this.getGenesForVcf(selectedVcf).keySet().stream().map(this::getPathwaysForGene).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Collection<Pathway> getPathwaysForGene(String gene) {
        try {
            return this.wikiPathwaysService.getPathwaysForGene(gene, HOMO_SAPIENS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/getColoredPathway/{selectedVcf}/{pathwayId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getColoredPathway(@PathVariable String selectedVcf, @PathVariable String pathwayId) throws ParserConfigurationException, SAXException, IOException, ExecutionException {
        return this.getColoredPathway(selectedVcf, pathwayId, this.analyzeGPML(this.wikiPathwaysService.getPathwayGPML(pathwayId)));
    }

    Multimap<String, String> analyzeGPML(String gpml) throws ParserConfigurationException, IOException, SAXException {
        return (Multimap)this.streamDataNodes(gpml).filter(node -> !node.getAttribute("GraphId").isEmpty()).collect(MultimapCollectors.toArrayListMultimap(node -> this.getGeneSymbol(node.getAttribute("TextLabel")), node -> node.getAttribute("GraphId")));
    }

    private Stream<Element> streamDataNodes(String gpml) {
        try {
            Document document = DB_FACTORY.newDocumentBuilder().parse(new InputSource(new StringReader(gpml)));
            NodeList dataNodes = document.getElementsByTagName("DataNode");
            return IntStream.range(0, dataNodes.getLength()).mapToObj(dataNodes::item).map(Element.class::cast);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("Invalid GPML " + gpml);
            throw new IllegalArgumentException("Invalid GPML");
        }
    }

    String getGeneSymbol(String textLabel) {
        Matcher geneSymbolMatcher;
        String geneSymbol = "";
        if (textLabel.contains("&quot;")) {
            LOG.warn("Textlabel(" + textLabel + ") contains quotes, which is inconsistent with the gene names. Removing the quotes.");
            textLabel = textLabel.replace("&quot;", "");
        }
        if ((geneSymbolMatcher = GENE_SYMBOL_PATTERN.matcher(textLabel)).find()) {
            geneSymbol = geneSymbolMatcher.group(0);
        }
        return geneSymbol;
    }

    private String getColoredPathway(String selectedVcf, String pathwayId, Multimap<String, String> graphIdsPerGene) throws ExecutionException {
        HashMap<String, Impact> impactPerGraphId = new HashMap<String, Impact>();
        this.getGenesForVcf(selectedVcf).forEach((gene, impact) -> graphIdsPerGene.get(gene).forEach(graphId -> impactPerGraphId.put((String)graphId, (Impact)((Object)impact))));
        if (!impactPerGraphId.isEmpty()) {
            return this.wikiPathwaysService.getColoredPathwayImage(pathwayId, impactPerGraphId);
        }
        return this.wikiPathwaysService.getUncoloredPathwayImage(pathwayId);
    }
}

