/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.python;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.molgenis.python.MolgenisPythonException;
import org.molgenis.python.PythonOutputHandler;
import org.molgenis.python.PythonStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PythonScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PythonScriptExecutor.class);
    private final String pythonScriptExecutable;

    public PythonScriptExecutor(@Value(value="${python_script_executable:/usr/bin/python}") String pythonScriptExecutable) {
        if (pythonScriptExecutable == null) {
            throw new IllegalArgumentException("pythonExecutable is null");
        }
        this.pythonScriptExecutable = pythonScriptExecutable;
    }

    public void executeScript(String pythonScript, PythonOutputHandler outputHandler) {
        File file = new File(this.pythonScriptExecutable);
        if (!file.exists()) {
            throw new MolgenisPythonException("File [" + this.pythonScriptExecutable + "] does not exist");
        }
        if (!file.canExecute()) {
            throw new MolgenisPythonException("Can not execute [" + this.pythonScriptExecutable + "]. Does it have executable permissions?");
        }
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile(null, ".py", new FileAttribute[0]);
            Files.write(tempFile, pythonScript.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
            String tempScriptFilePath = tempFile.toAbsolutePath().toString();
            LOG.info("Running python script [{}]", (Object)tempScriptFilePath);
            Process process = Runtime.getRuntime().exec(PythonScriptExecutor.getCommand(this.pythonScriptExecutable, tempScriptFilePath));
            StringBuilder sb = new StringBuilder();
            PythonStreamHandler errorHandler = new PythonStreamHandler(process.getErrorStream(), output -> sb.append(output).append("\n"));
            errorHandler.start();
            if (outputHandler != null) {
                PythonStreamHandler streamHandler = new PythonStreamHandler(process.getInputStream(), outputHandler);
                streamHandler.start();
            }
            process.waitFor();
            if (process.exitValue() > 0) {
                throw new MolgenisPythonException("Error running [" + tempScriptFilePath + "]." + sb.toString());
            }
            LOG.info("Script [{}] done", (Object)tempScriptFilePath);
        }
        catch (IOException e) {
            throw new MolgenisPythonException("Exception executing PythonScipt.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MolgenisPythonException("Exception waiting for PythonScipt to finish", e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    protected static String[] getCommand(String pythonScriptExecutable, String tempScriptFilePath) {
        String[] cmdArray = new String[]{pythonScriptExecutable, tempScriptFilePath};
        return cmdArray;
    }
}

