/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.questionnaires.QuestionnaireUtils;
import org.molgenis.questionnaires.ThankYouTextService;
import org.molgenis.ui.MolgenisPluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/plugin/questionnaireThankYouPage"})
public class ThankYouPageEditorController
extends MolgenisPluginController {
    public static final String ID = "questionnaireThankYouPage";
    public static final String URI = "/plugin/questionnaireThankYouPage";
    private final ThankYouTextService thankYouTextService;
    private final DataService dataService;

    @Autowired
    public ThankYouPageEditorController(DataService dataService, ThankYouTextService thankYouTextService) {
        super(URI);
        this.thankYouTextService = thankYouTextService;
        this.dataService = dataService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(@RequestParam(value="questionnaireName", required=false) String questionnaireName, @RequestParam(value="edit", required=false, defaultValue="false") String edit, Model model, HttpServletResponse response) throws IOException {
        if (questionnaireName != null && this.dataService.getMeta().getEntityMetaData(questionnaireName) == null) {
            response.sendError(404);
            return null;
        }
        if (edit.equalsIgnoreCase("true") && questionnaireName != null) {
            model.addAttribute("edit", (Object)true);
        }
        ArrayList questionnaires = Lists.newArrayList(QuestionnaireUtils.findQuestionnairesMetaData(this.dataService));
        model.addAttribute("questionnaires", (Object)questionnaires);
        if (questionnaireName == null && !questionnaires.isEmpty()) {
            questionnaireName = ((Entity)questionnaires.get(0)).getString("fullName");
        }
        model.addAttribute("content", (Object)this.thankYouTextService.getThankYouText(questionnaireName));
        model.addAttribute("selectedQuestionnaire", (Object)questionnaireName);
        return "view-thank-you-text";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String save(@RequestParam(value="questionnaireName") String questionnaireName, @RequestParam(value="content") String content, Model model) {
        if (this.dataService.getMeta().getEntityMetaData(questionnaireName) != null) {
            this.thankYouTextService.saveThankYouText(questionnaireName, content);
        }
        ArrayList questionnaires = Lists.newArrayList(QuestionnaireUtils.findQuestionnairesMetaData(this.dataService));
        model.addAttribute("questionnaires", (Object)questionnaires);
        model.addAttribute("content", (Object)content);
        model.addAttribute("selectedQuestionnaire", (Object)questionnaireName);
        return "view-thank-you-text";
    }
}

