/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.support.DefaultEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.questionnaires.QuestionnaireStatus;
import org.molgenis.questionnaires.QuestionnaireUtils;
import org.molgenis.questionnaires.ThankYouTextService;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.ui.MolgenisPluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/plugin/questionnaires"})
public class QuestionnairePluginController
extends MolgenisPluginController {
    public static final String ID = "questionnaires";
    public static final String URI = "/plugin/questionnaires";
    private final DataService dataService;
    private final ThankYouTextService thankYouTextService;
    private final LanguageService languageService;

    @Autowired
    public QuestionnairePluginController(DataService dataService, ThankYouTextService thankYouTextService, LanguageService languageService) {
        super(URI);
        this.dataService = dataService;
        this.thankYouTextService = thankYouTextService;
        this.languageService = languageService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showView(Model model) {
        List questionnaireMeta = (List)RunAsSystemProxy.runAsSystem(() -> QuestionnaireUtils.findQuestionnairesMetaData(this.dataService).collect(Collectors.toList()));
        List questionnaires = questionnaireMeta.stream().map(e -> e.getString("fullName")).filter(name -> SecurityUtils.currentUserIsSu() || SecurityUtils.currentUserHasRole((String[])new String[]{SecurityUtils.AUTHORITY_ENTITY_WRITE_PREFIX + name.toUpperCase()})).map(name -> {
            EntityMetaData emd = this.dataService.getMeta().getEntityMetaData(name);
            Entity entity = this.findQuestionnaireEntity((String)name);
            if (entity == null) {
                entity = this.createQuestionnaireEntity(emd, QuestionnaireStatus.NOT_STARTED);
            }
            return this.toQuestionnaireModel(entity, emd);
        }).collect(Collectors.toList());
        model.addAttribute(ID, questionnaires);
        return "view-my-questionnaires";
    }

    @RequestMapping(value={"/{name}"})
    public String showQuestionnairForm(@PathVariable(value="name") String name, Model model, HttpServletResponse response) throws IOException {
        EntityMetaData emd = this.dataService.getMeta().getEntityMetaData(name);
        if (emd == null) {
            response.sendError(404);
            return null;
        }
        Entity entity = this.findQuestionnaireEntity(name);
        if (entity == null) {
            entity = this.createQuestionnaireEntity(emd, QuestionnaireStatus.OPEN);
        } else if (entity.getString("status").equals(QuestionnaireStatus.NOT_STARTED.toString())) {
            entity.set("status", (Object)QuestionnaireStatus.OPEN);
            this.dataService.update(name, entity);
        }
        model.addAttribute("questionnaire", (Object)this.toQuestionnaireModel(entity, emd));
        return "view-questionnaire";
    }

    @RequestMapping(value={"/{name}/thanks"})
    public String showThanks(@PathVariable(value="name") String name, Model model, HttpServletResponse response) throws IOException {
        EntityMetaData emd = this.dataService.getMeta().getEntityMetaData(name);
        if (emd == null) {
            response.sendError(404);
            return null;
        }
        model.addAttribute("thankYouText", (Object)this.getThankYouText(name));
        return "view-thanks";
    }

    private Entity createQuestionnaireEntity(EntityMetaData emd, QuestionnaireStatus status) {
        DefaultEntity entity = new DefaultEntity(emd, this.dataService);
        entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
        entity.set("status", (Object)status.toString());
        this.dataService.add(emd.getName(), (Entity)entity);
        return entity;
    }

    private Questionnaire toQuestionnaireModel(Entity entity, EntityMetaData emd) {
        QuestionnaireStatus status = QuestionnaireStatus.valueOf(entity.getString("status"));
        return new Questionnaire(emd.getName(), emd.getLabel(this.languageService.getCurrentUserLanguageCode()), status, emd.getDescription(this.languageService.getCurrentUserLanguageCode()), entity.getIdValue());
    }

    private Entity findQuestionnaireEntity(String name) {
        return this.dataService.findOne(name, QueryImpl.EQ((String)"ownerUsername", (Object)SecurityUtils.getCurrentUsername()));
    }

    public String getThankYouText(String questionnaireName) {
        return (String)RunAsSystemProxy.runAsSystem(() -> this.thankYouTextService.getThankYouText(questionnaireName));
    }

    public static class Questionnaire {
        private String name;
        private String label;
        private QuestionnaireStatus status;
        private String description;
        private Object id;

        public Questionnaire(String name, String label, QuestionnaireStatus status, String description, Object id) {
            this.name = name;
            this.label = label;
            this.status = status;
            this.description = description;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public QuestionnaireStatus getStatus() {
            return this.status;
        }

        public void setStatus(QuestionnaireStatus status) {
            this.status = status;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }
    }
}

