/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires;

import java.util.ArrayList;
import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.owned.OwnedEntityType;
import org.molgenis.questionnaires.QuestionnaireStatus;
import org.springframework.stereotype.Component;

@Component
public class QuestionnaireMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "Questionnaire";
    public static final String QUESTIONNAIRE = "sys_Questionnaire";
    public static final String ATTR_STATUS = "status";
    public static final String SUBMIT_DATE = "submitDate";
    private final OwnedEntityType ownedEntityType;

    QuestionnaireMetaData(OwnedEntityType ownedEntityType) {
        super(SIMPLE_NAME, "sys");
        this.ownedEntityType = Objects.requireNonNull(ownedEntityType);
    }

    public void init() {
        this.setLabel(SIMPLE_NAME);
        this.setAbstract(true);
        this.setExtends((EntityType)this.ownedEntityType);
        ArrayList<String> enumOptions = new ArrayList<String>();
        for (QuestionnaireStatus questionnaireStatus : QuestionnaireStatus.values()) {
            enumOptions.add(questionnaireStatus.toString());
        }
        this.addAttribute(ATTR_STATUS, new EntityType.AttributeRole[0]).setDataType(AttributeType.ENUM).setEnumOptions(enumOptions).setVisible(false).setNillable(false);
        this.addAttribute(SUBMIT_DATE, new EntityType.AttributeRole[0]).setDataType(AttributeType.DATE_TIME).setLabel("Submit date").setNullableExpression("$('status').value() !== '" + QuestionnaireStatus.SUBMITTED.toString() + "'").setVisibleExpression("$('status').value() === '" + QuestionnaireStatus.SUBMITTED.toString() + "'");
    }
}

