/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.i18n.LanguageService;
import org.molgenis.questionnaires.QuestionnaireStatus;
import org.molgenis.questionnaires.QuestionnaireUtils;
import org.molgenis.questionnaires.ThankYouTextService;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.web.PluginController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/plugin/questionnaires"})
public class QuestionnairePluginController
extends PluginController {
    public static final String ID = "questionnaires";
    public static final String URI = "/plugin/questionnaires";
    private final DataService dataService;
    private final ThankYouTextService thankYouTextService;
    private final EntityManager entityManager;

    public QuestionnairePluginController(DataService dataService, ThankYouTextService thankYouTextService, EntityManager entityManager) {
        super(URI);
        this.dataService = Objects.requireNonNull(dataService);
        this.thankYouTextService = Objects.requireNonNull(thankYouTextService);
        this.entityManager = Objects.requireNonNull(entityManager);
    }

    @GetMapping
    public String showView(Model model) {
        model.addAttribute(ID, this.getQuestionnaires());
        return "view-my-questionnaires";
    }

    private List<Questionnaire> getQuestionnaires() {
        List questionnaireMeta = (List)RunAsSystemAspect.runAsSystem(() -> QuestionnaireUtils.findQuestionnairesMetaData(this.dataService).collect(Collectors.toList()));
        List<Questionnaire> questionnaires = questionnaireMeta.stream().map(EntityType::getId).filter(name -> SecurityUtils.currentUserIsSu() || SecurityUtils.currentUserHasRole((String[])new String[]{SecurityUtils.AUTHORITY_ENTITY_WRITE_PREFIX + name})).map(name -> {
            EntityType entityType = this.dataService.getMeta().getEntityType(name);
            Entity entity = this.findQuestionnaireEntity((String)name);
            if (entity == null) {
                entity = this.createQuestionnaireEntity(entityType, QuestionnaireStatus.NOT_STARTED, (String)name);
            }
            return this.toQuestionnaireModel(entity, entityType);
        }).collect(Collectors.toList());
        return questionnaires;
    }

    @GetMapping(value={"/{name}"})
    public String showQuestionnairForm(@PathVariable(value="name") String name, Model model, HttpServletResponse response) throws IOException {
        EntityType entityType = this.dataService.getMeta().getEntityType(name);
        if (entityType == null) {
            response.sendError(404);
            return null;
        }
        Entity entity = this.findQuestionnaireEntity(name);
        if (entity == null) {
            entity = this.createQuestionnaireEntity(entityType, QuestionnaireStatus.OPEN, name);
        } else if (entity.getString("status").equals(QuestionnaireStatus.NOT_STARTED.toString())) {
            entity.set("status", (Object)QuestionnaireStatus.OPEN.toString());
            this.dataService.update(name, entity);
        }
        model.addAttribute("questionnaire", (Object)this.toQuestionnaireModel(entity, entityType));
        return "view-questionnaire";
    }

    @GetMapping(value={"/{name}/thanks"})
    public String showThanks(@PathVariable(value="name") String name, Model model, HttpServletResponse response) throws IOException {
        EntityType entityType = this.dataService.getMeta().getEntityType(name);
        if (entityType == null) {
            response.sendError(404);
            return null;
        }
        model.addAttribute("thankYouText", (Object)this.getThankYouText(name));
        return "view-thanks";
    }

    private synchronized Entity createQuestionnaireEntity(EntityType entityType, QuestionnaireStatus status, String name) {
        Entity entity = this.findQuestionnaireEntity(name);
        if (entity == null) {
            entity = this.entityManager.create(entityType, EntityManager.CreationMode.POPULATE);
            entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
            entity.set("status", (Object)status.toString());
            this.dataService.add(entityType.getId(), entity);
        }
        return entity;
    }

    private Questionnaire toQuestionnaireModel(Entity entity, EntityType entityType) {
        QuestionnaireStatus status = QuestionnaireStatus.valueOf(entity.getString("status"));
        return new Questionnaire(entityType.getId(), entityType.getLabel(LanguageService.getCurrentUserLanguageCode()), status, entityType.getDescription(LanguageService.getCurrentUserLanguageCode()), entity.getIdValue());
    }

    private Entity findQuestionnaireEntity(String name) {
        return this.dataService.findOne(name, QueryImpl.EQ((String)"ownerUsername", (Object)SecurityUtils.getCurrentUsername()));
    }

    private String getThankYouText(String questionnaireName) {
        return (String)RunAsSystemAspect.runAsSystem(() -> this.thankYouTextService.getThankYouText(questionnaireName));
    }

    public static class Questionnaire {
        private String name;
        private String label;
        private QuestionnaireStatus status;
        private String description;
        private Object id;

        Questionnaire(String name, String label, QuestionnaireStatus status, String description, Object id) {
            this.name = name;
            this.label = label;
            this.status = status;
            this.description = description;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public QuestionnaireStatus getStatus() {
            return this.status;
        }

        public void setStatus(QuestionnaireStatus status) {
            this.status = status;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }
    }
}

