/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.questionnaires.QuestionnaireUtils;
import org.molgenis.questionnaires.ThankYouTextService;
import org.molgenis.web.PluginController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/plugin/questionnaireThankYouPage"})
public class ThankYouPageEditorController
extends PluginController {
    public static final String ID = "questionnaireThankYouPage";
    public static final String URI = "/plugin/questionnaireThankYouPage";
    private final ThankYouTextService thankYouTextService;
    private final DataService dataService;

    public ThankYouPageEditorController(DataService dataService, ThankYouTextService thankYouTextService) {
        super(URI);
        this.thankYouTextService = thankYouTextService;
        this.dataService = dataService;
    }

    @GetMapping
    public String view(@RequestParam(value="questionnaireName", required=false) String questionnaireName, @RequestParam(value="edit", required=false, defaultValue="false") String edit, Model model, HttpServletResponse response) throws IOException {
        if (questionnaireName != null && this.dataService.getMeta().getEntityType(questionnaireName) == null) {
            response.sendError(404);
            return null;
        }
        if (edit.equalsIgnoreCase("true") && questionnaireName != null) {
            model.addAttribute("edit", (Object)true);
        }
        List questionnaires = QuestionnaireUtils.findQuestionnairesMetaData(this.dataService).collect(Collectors.toList());
        model.addAttribute("questionnaires", questionnaires);
        if (questionnaireName == null && !questionnaires.isEmpty()) {
            questionnaireName = ((EntityType)questionnaires.get(0)).getId();
        }
        model.addAttribute("content", (Object)this.thankYouTextService.getThankYouText(questionnaireName));
        model.addAttribute("selectedQuestionnaire", (Object)questionnaireName);
        return "view-thank-you-text";
    }

    @PostMapping
    public String save(@RequestParam(value="questionnaireName") String questionnaireName, @RequestParam(value="content") String content, Model model) {
        if (this.dataService.getMeta().getEntityType(questionnaireName) != null) {
            this.thankYouTextService.saveThankYouText(questionnaireName, content);
        }
        List questionnaires = QuestionnaireUtils.findQuestionnairesMetaData(this.dataService).collect(Collectors.toList());
        model.addAttribute("questionnaires", questionnaires);
        model.addAttribute("content", (Object)content);
        model.addAttribute("selectedQuestionnaire", (Object)questionnaireName);
        return "view-thank-you-text";
    }
}

