/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires.controller;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.core.ui.controller.VuePluginController;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.questionnaires.meta.Questionnaire;
import org.molgenis.questionnaires.meta.QuestionnaireStatus;
import org.molgenis.questionnaires.response.QuestionnaireResponse;
import org.molgenis.questionnaires.service.QuestionnaireService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.settings.AppSettings;
import org.molgenis.web.menu.MenuReaderService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/questionnaires"})
public class QuestionnaireController
extends VuePluginController {
    public static final String ID = "questionnaires";
    public static final String URI = "/plugin/questionnaires";
    private static final String QUESTIONNAIRE_VIEW = "view-questionnaire";
    private final QuestionnaireService questionnaireService;

    public QuestionnaireController(QuestionnaireService questionnaireService, MenuReaderService menuReaderService, AppSettings appSettings, UserAccountService userAccountService) {
        super(URI, menuReaderService, appSettings, userAccountService);
        this.questionnaireService = Objects.requireNonNull(questionnaireService);
    }

    @GetMapping(value={"/**"})
    public String initView(Model model) {
        super.init(model, ID);
        model.addAttribute("username", (Object)this.userAccountService.getCurrentUser().getUsername());
        return QUESTIONNAIRE_VIEW;
    }

    @ResponseBody
    @GetMapping(value={"/list"})
    public List<QuestionnaireResponse> getQuestionnaires() {
        return this.questionnaireService.getQuestionnaires().map(this::createQuestionnaireResponse).collect(Collectors.toList());
    }

    @GetMapping(value={"/start/{id}"})
    @ResponseBody
    public QuestionnaireResponse startQuestionnaire(@PathVariable(value="id") String id) {
        return this.questionnaireService.startQuestionnaire(id);
    }

    @ResponseBody
    @GetMapping(value={"/submission-text/{id}"})
    public String getQuestionnaireSubmissionText(@PathVariable(value="id") String id) {
        return this.questionnaireService.getQuestionnaireSubmissionText(id);
    }

    private QuestionnaireResponse createQuestionnaireResponse(EntityType entityType) {
        String entityTypeId = entityType.getId();
        QuestionnaireStatus status = QuestionnaireStatus.NOT_STARTED;
        Questionnaire questionnaireEntity = this.questionnaireService.findQuestionnaireEntity(entityTypeId);
        if (questionnaireEntity != null) {
            status = questionnaireEntity.getStatus();
        }
        String lng = this.getLanguageCode();
        return QuestionnaireResponse.create(entityTypeId, entityType.getLabel(lng), entityType.getDescription(lng), status);
    }
}

