/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.questionnaires.service.impl;

import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.core.ui.controller.StaticContentService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.EntityIdentityUtils;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.questionnaires.exception.QuestionnaireNotRowLevelSecuredException;
import org.molgenis.questionnaires.meta.Questionnaire;
import org.molgenis.questionnaires.meta.QuestionnaireFactory;
import org.molgenis.questionnaires.meta.QuestionnaireStatus;
import org.molgenis.questionnaires.response.QuestionnaireResponse;
import org.molgenis.questionnaires.service.QuestionnaireService;
import org.molgenis.security.acl.MutableAclClassService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Service;

@Service
public class QuestionnaireServiceImpl
implements QuestionnaireService {
    private static final String DEFAULT_SUBMISSION_TEXT = "<h3>Thank you for submitting the questionnaire.</h3>";
    private final DataService dataService;
    private final EntityManager entityManager;
    private final UserPermissionEvaluator userPermissionEvaluator;
    private final QuestionnaireFactory questionnaireFactory;
    private final StaticContentService staticContentService;
    private final MutableAclClassService mutableAclClassService;

    public QuestionnaireServiceImpl(DataService dataService, EntityManager entityManager, UserPermissionEvaluator userPermissionEvaluator, QuestionnaireFactory questionnaireFactory, StaticContentService staticContentService, MutableAclClassService mutableAclClassService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.entityManager = Objects.requireNonNull(entityManager);
        this.userPermissionEvaluator = Objects.requireNonNull(userPermissionEvaluator);
        this.questionnaireFactory = Objects.requireNonNull(questionnaireFactory);
        this.staticContentService = Objects.requireNonNull(staticContentService);
        this.mutableAclClassService = Objects.requireNonNull(mutableAclClassService);
    }

    @Override
    public Stream<EntityType> getQuestionnaires() {
        return this.dataService.query("sys_md_EntityType", EntityType.class).eq("extends", (Object)"sys_Questionnaire").findAll().filter(entityType -> this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityType.getId()), (Permission)EntityTypePermission.ADD_DATA)).filter(entityType -> this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityType.getId()), (Permission)EntityTypePermission.UPDATE_DATA));
    }

    @Override
    public QuestionnaireResponse startQuestionnaire(String entityTypeId) {
        Questionnaire questionnaire = this.findQuestionnaireEntity(entityTypeId);
        if (questionnaire == null) {
            EntityType questionnaireEntityType = this.dataService.getEntityType(entityTypeId);
            boolean rlsEnabled = this.mutableAclClassService.getAclClassTypes().contains(EntityIdentityUtils.toType((EntityType)questionnaireEntityType));
            if (!rlsEnabled) {
                throw new QuestionnaireNotRowLevelSecuredException(questionnaireEntityType);
            }
            questionnaire = (Questionnaire)this.questionnaireFactory.create(this.entityManager.create(questionnaireEntityType, EntityManager.CreationMode.POPULATE));
            questionnaire.setOwner(SecurityUtils.getCurrentUsername());
            questionnaire.setStatus(QuestionnaireStatus.OPEN);
            this.dataService.add(entityTypeId, (Entity)questionnaire);
            Questionnaire newQuestionnaire = this.findQuestionnaireEntity(questionnaire.getEntityType().getId());
            return QuestionnaireResponse.create(newQuestionnaire);
        }
        return QuestionnaireResponse.create(questionnaire);
    }

    @Override
    public String getQuestionnaireSubmissionText(String id) {
        String key = id + "_submissionText";
        String submissionText = this.staticContentService.getContent(key);
        if (submissionText == null) {
            submissionText = DEFAULT_SUBMISSION_TEXT;
            this.staticContentService.submitContent(key, submissionText);
        }
        return submissionText;
    }

    @Override
    @Nullable
    @CheckForNull
    public Questionnaire findQuestionnaireEntity(String entityTypeId) {
        Entity questionnaireInstance = this.dataService.query(entityTypeId).eq("owner", (Object)SecurityUtils.getCurrentUsername()).findOne();
        if (questionnaireInstance != null) {
            return (Questionnaire)this.questionnaireFactory.create(questionnaireInstance);
        }
        return null;
    }
}

