/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.molgenis.r.MolgenisRException;
import org.molgenis.r.ROutputHandler;
import org.molgenis.r.RStreamHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RScriptExecutor {
    private static final Logger logger = Logger.getLogger(RScriptExecutor.class);
    private final String rScriptExecutable;

    @Autowired
    public RScriptExecutor(@Value(value="${r_script_executable:/usr/bin/Rscript}") String rScriptExecutable) {
        if (rScriptExecutable == null) {
            throw new IllegalArgumentException("rExecutable is null");
        }
        this.rScriptExecutable = rScriptExecutable;
    }

    public void executeScript(File script, ROutputHandler outputHandler) {
        File file = new File(this.rScriptExecutable);
        if (!file.exists()) {
            throw new MolgenisRException("File [" + this.rScriptExecutable + "] does not exist");
        }
        if (!file.canExecute()) {
            throw new MolgenisRException("Can not execute [" + this.rScriptExecutable + "]. Does it have executable permissions?");
        }
        if (!script.exists()) {
            throw new MolgenisRException("File [" + script + "] does not exist");
        }
        try {
            logger.info((Object)("Running r script [" + script.getAbsolutePath() + "]"));
            Process process = Runtime.getRuntime().exec(this.rScriptExecutable + " " + script.getAbsolutePath());
            final StringBuilder sb = new StringBuilder();
            RStreamHandler errorHandler = new RStreamHandler(process.getErrorStream(), new ROutputHandler(){

                @Override
                public void outputReceived(String output) {
                    sb.append(output).append("\n");
                }
            });
            errorHandler.start();
            if (outputHandler != null) {
                RStreamHandler streamHandler = new RStreamHandler(process.getInputStream(), outputHandler);
                streamHandler.start();
            }
            process.waitFor();
            if (process.exitValue() > 0) {
                throw new MolgenisRException("Error running [" + script.getAbsolutePath() + "]." + sb.toString());
            }
            logger.info((Object)("Script [" + script.getAbsolutePath() + "] done"));
        }
        catch (IOException e) {
            throw new MolgenisRException("Exception executing RScipt.", e);
        }
        catch (InterruptedException e) {
            throw new MolgenisRException("Exception waiting for RScipt to finish", e);
        }
    }
}

