/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.molgenis.r.MolgenisRException;
import org.molgenis.r.ROutputHandler;
import org.molgenis.r.RStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RScriptExecutor.class);
    private final String rScriptExecutable;
    private final String rLibs;

    @Autowired
    public RScriptExecutor(@Value(value="${r_script_executable:/usr/bin/Rscript}") String rScriptExecutable, @Value(value="${r_libs:@null}") String rLibs) {
        this.rScriptExecutable = (String)Preconditions.checkNotNull((Object)rScriptExecutable);
        this.rLibs = rLibs == null ? System.getProperty("user.home") + File.separator + "r-packages" : rLibs;
    }

    public void executeScript(File script, ROutputHandler outputHandler) {
        File file = new File(this.rScriptExecutable);
        if (!file.exists()) {
            throw new MolgenisRException("File [" + this.rScriptExecutable + "] does not exist");
        }
        if (!file.canExecute()) {
            throw new MolgenisRException("Can not execute [" + this.rScriptExecutable + "]. Does it have executable permissions?");
        }
        if (!script.exists()) {
            throw new MolgenisRException("File [" + script + "] does not exist");
        }
        try {
            LOG.info("Running r script [" + script.getAbsolutePath() + "]");
            ProcessBuilder processBuilder = new ProcessBuilder(this.rScriptExecutable, script.getAbsolutePath());
            processBuilder.environment().put("R_LIBS", this.rLibs);
            Process process = processBuilder.start();
            final StringBuilder sb = new StringBuilder();
            RStreamHandler errorHandler = new RStreamHandler(process.getErrorStream(), new ROutputHandler(){

                @Override
                public void outputReceived(String output) {
                    sb.append(output).append("\n");
                }
            });
            errorHandler.start();
            if (outputHandler != null) {
                RStreamHandler streamHandler = new RStreamHandler(process.getInputStream(), outputHandler);
                streamHandler.start();
            }
            process.waitFor();
            if (process.exitValue() > 0) {
                throw new MolgenisRException("Error running [" + script.getAbsolutePath() + "]." + sb.toString());
            }
            LOG.info("Script [" + script.getAbsolutePath() + "] done");
        }
        catch (IOException e) {
            throw new MolgenisRException("Exception executing RScipt.", e);
        }
        catch (InterruptedException e) {
            throw new MolgenisRException("Exception waiting for RScipt to finish", e);
        }
    }
}

