/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.molgenis.file.FileStore;
import org.molgenis.r.ROutputHandler;
import org.molgenis.r.RScriptExecutor;
import org.molgenis.r.StringROutputHandler;
import org.molgenis.script.Script;
import org.molgenis.script.ScriptRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class RScriptRunner
implements ScriptRunner {
    private static final String NAME = "R";
    private static final Charset CHARSET = Charset.forName("utf-8");
    private final RScriptExecutor rScriptExecutor;
    private final FileStore fileStore;
    private final FreeMarkerConfigurer freeMarkerConfig;

    @Autowired
    public RScriptRunner(RScriptExecutor rScriptExecutor, FileStore fileStore, FreeMarkerConfigurer freeMarkerConfig) {
        this.rScriptExecutor = rScriptExecutor;
        this.fileStore = fileStore;
        this.freeMarkerConfig = freeMarkerConfig;
    }

    public void runRScript(String templateName, Map<String, Object> parameters, ROutputHandler outputHandler) throws IOException, TemplateException {
        String scriptName = this.generateRandomRScriptName();
        this.runRScript(scriptName, templateName, parameters, outputHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRScript(String scriptName, String templateName, Map<String, Object> parameters, ROutputHandler outputHandler) throws IOException, TemplateException {
        File rScriptFile = this.fileStore.getFile(scriptName);
        Template template = this.freeMarkerConfig.getConfiguration().getTemplate(templateName);
        FileWriterWithEncoding w = new FileWriterWithEncoding(rScriptFile, CHARSET);
        try {
            template.process(parameters, (Writer)w);
        }
        finally {
            IOUtils.closeQuietly((Writer)w);
        }
        this.rScriptExecutor.executeScript(rScriptFile, outputHandler);
    }

    public void runRScript(String script, ROutputHandler outputHandler) throws FileNotFoundException, IOException {
        String scriptName = this.generateRandomRScriptName();
        File file = this.fileStore.getFile(scriptName);
        FileCopyUtils.copy((String)script, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), CHARSET));
        this.rScriptExecutor.executeScript(file, outputHandler);
    }

    public String getName() {
        return NAME;
    }

    public String runScript(Script script, Map<String, Object> parameters) {
        File rScriptFile = script.generateScript(this.fileStore, NAME, parameters);
        StringROutputHandler handler = new StringROutputHandler();
        this.runRScript(rScriptFile, (ROutputHandler)handler);
        return handler.toString();
    }

    public void runRScript(File script, ROutputHandler outputHandler) {
        this.rScriptExecutor.executeScript(script, outputHandler);
    }

    private String generateRandomRScriptName() {
        return UUID.randomUUID().toString().replaceAll("-", "") + ".R";
    }
}

