/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.molgenis.r.MolgenisRException;
import org.molgenis.r.ROutputHandler;
import org.molgenis.r.RStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RScriptExecutor.class);
    private final String rScriptExecutable;
    private final String rLibs;

    @Autowired
    public RScriptExecutor(@Value(value="${r_script_executable:/usr/bin/Rscript}") String rScriptExecutable, @Value(value="${r_libs:@null}") String rLibs) {
        this.rScriptExecutable = Objects.requireNonNull(rScriptExecutable);
        this.rLibs = rLibs == null ? System.getProperty("user.home") + File.separator + "r-packages" : rLibs;
    }

    public void executeScript(String rScript, ROutputHandler outputHandler) {
        File file = new File(this.rScriptExecutable);
        if (!file.exists()) {
            throw new MolgenisRException("File [" + this.rScriptExecutable + "] does not exist");
        }
        if (!file.canExecute()) {
            throw new MolgenisRException("Can not execute [" + this.rScriptExecutable + "]. Does it have executable permissions?");
        }
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile(null, ".R", new FileAttribute[0]);
            Files.write(tempFile, rScript.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
            String tempScriptFilePath = tempFile.toAbsolutePath().toString();
            LOG.info("Running r script [" + tempScriptFilePath + "]");
            ProcessBuilder processBuilder = new ProcessBuilder(this.rScriptExecutable, tempScriptFilePath);
            processBuilder.environment().put("R_LIBS", this.rLibs);
            Process process = processBuilder.start();
            final StringBuilder sb = new StringBuilder();
            RStreamHandler errorHandler = new RStreamHandler(process.getErrorStream(), new ROutputHandler(){

                @Override
                public void outputReceived(String output) {
                    sb.append(output).append("\n");
                }
            });
            errorHandler.start();
            if (outputHandler != null) {
                RStreamHandler streamHandler = new RStreamHandler(process.getInputStream(), outputHandler);
                streamHandler.start();
            }
            process.waitFor();
            if (process.exitValue() > 0) {
                throw new MolgenisRException("Error running [" + tempScriptFilePath + "]." + sb.toString());
            }
            LOG.info("Script [" + tempScriptFilePath + "] done");
        }
        catch (IOException e) {
            throw new MolgenisRException("Exception executing RScipt.", e);
        }
        catch (InterruptedException e) {
            throw new MolgenisRException("Exception waiting for RScipt to finish", e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }
}

