/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.settings.DefaultSettingsEntity;
import org.molgenis.data.settings.DefaultSettingsEntityType;
import org.molgenis.r.OpenCpuSettings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OpenCpuSettingsImpl
extends DefaultSettingsEntity
implements OpenCpuSettings {
    private static final long serialVersionUID = 1L;
    private static final String ID = "OpenCpuSettings";

    public OpenCpuSettingsImpl() {
        super(ID);
    }

    @Override
    public String getScheme() {
        return this.getString("scheme");
    }

    @Override
    public String getHost() {
        return this.getString("host");
    }

    @Override
    public int getPort() {
        return this.getInt("port");
    }

    @Override
    public String getRootPath() {
        return this.getString("rootPath");
    }

    @Component
    public static class Meta
    extends DefaultSettingsEntityType {
        @Value(value="${opencpu.uri.scheme:http}")
        private String defaultScheme;
        @Value(value="${opencpu.uri.host:localhost}")
        private String defaultHost;
        @Value(value="${opencpu.uri.port:8004}")
        private String defaultPort;
        @Value(value="${opencpu.uri.path:/ocpu/}")
        private String defaultRootPath;
        static final String SCHEME = "scheme";
        static final String HOST = "host";
        static final String PORT = "port";
        static final String ROOT_PATH = "rootPath";

        public Meta() {
            super(OpenCpuSettingsImpl.ID);
        }

        public void init() {
            super.init();
            this.setLabel("OpenCPU settings");
            this.setDescription("OpenCPU, a framework for embedded scientific computing and reproducible research, settings.");
            this.addAttribute(SCHEME, new EntityType.AttributeRole[0]).setDefaultValue(this.defaultScheme).setNillable(false).setLabel("URI scheme").setDescription("Open CPU URI scheme (e.g. http).");
            this.addAttribute(HOST, new EntityType.AttributeRole[0]).setDefaultValue(this.defaultHost).setNillable(false).setLabel("URI host").setDescription("Open CPU URI host (e.g. localhost).");
            this.addAttribute(PORT, new EntityType.AttributeRole[0]).setDataType(AttributeType.INT).setDefaultValue(this.defaultPort).setNillable(false).setLabel("URI port").setDescription("Open CPU URI port (e.g. 8004).");
            this.addAttribute(ROOT_PATH, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setDefaultValue(this.defaultRootPath).setNillable(false).setLabel("URI path").setDescription("Open CPU URI root path (e.g. /ocpu/).");
        }
    }
}

