/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import java.util.Map;
import java.util.Objects;
import org.molgenis.r.RScriptExecutor;
import org.molgenis.script.Script;
import org.molgenis.script.ScriptRunner;
import org.molgenis.script.ScriptUtils;
import org.springframework.stereotype.Service;

@Service
public class RScriptRunner
implements ScriptRunner {
    private static final String NAME = "R";
    private final RScriptExecutor rScriptExecutor;

    public RScriptRunner(RScriptExecutor rScriptExecutor) {
        this.rScriptExecutor = Objects.requireNonNull(rScriptExecutor);
    }

    public String getName() {
        return NAME;
    }

    public String runScript(Script script, Map<String, Object> parameters) {
        String rScript = ScriptUtils.generateScript((Script)script, parameters);
        String outputFile = this.getOutputFile(parameters);
        return this.rScriptExecutor.executeScript(rScript, outputFile);
    }

    private String getOutputFile(Map<String, Object> parameters) {
        Object outputFile = parameters.get("outputFile");
        if (outputFile == null) {
            return null;
        }
        if (!(outputFile instanceof String)) {
            throw new RuntimeException(String.format("Parameter outputFile is of type '%s' instead of '%s'", outputFile.getClass().getSimpleName(), String.class.getSimpleName()));
        }
        return (String)outputFile;
    }
}

