/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.r;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.molgenis.r.OpenCpuSettings;
import org.molgenis.script.core.ScriptException;
import org.springframework.stereotype.Service;

@Service
public class RScriptExecutor {
    private final CloseableHttpClient httpClient;
    private final OpenCpuSettings openCpuSettings;

    public RScriptExecutor(CloseableHttpClient httpClient, OpenCpuSettings openCpuSettings) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.openCpuSettings = Objects.requireNonNull(openCpuSettings);
    }

    String executeScript(String script, String outputPathname) {
        String scriptOutputFilename;
        if (outputPathname != null) {
            scriptOutputFilename = this.generateRandomString();
            script = script.replace(outputPathname, scriptOutputFilename);
        } else {
            scriptOutputFilename = null;
        }
        try {
            String openCpuSessionKey = this.executeScriptExecuteRequest(script);
            return this.executeScriptGetResponseRequest(openCpuSessionKey, scriptOutputFilename, outputPathname);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String executeScriptExecuteRequest(String rScript) throws IOException {
        String openCpuSessionKey;
        block15: {
            URI uri = this.getScriptExecutionUri();
            HttpPost httpPost = new HttpPost(uri);
            BasicNameValuePair nameValuePair = new BasicNameValuePair("x", rScript);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(Collections.singletonList(nameValuePair)));
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    Header openCpuSessionKeyHeader = response.getFirstHeader("X-ocpu-session");
                    if (openCpuSessionKeyHeader == null) {
                        throw new IOException("Missing 'X-ocpu-session' header");
                    }
                    openCpuSessionKey = openCpuSessionKeyHeader.getValue();
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    break block15;
                }
                if (statusCode == 400) {
                    HttpEntity entity = response.getEntity();
                    String rErrorMessage = EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                    throw new ScriptException(rErrorMessage);
                }
                throw new ClientProtocolException(String.format("Unexpected response status: %d", statusCode));
            }
        }
        return openCpuSessionKey;
    }

    private String executeScriptGetResponseRequest(String openCpuSessionKey, String scriptOutputFilename, String outputPathname) throws IOException {
        String responseValue;
        if (scriptOutputFilename != null) {
            this.executeScriptGetFileRequest(openCpuSessionKey, scriptOutputFilename, outputPathname);
            responseValue = null;
        } else {
            responseValue = this.executeScriptGetValueRequest(openCpuSessionKey);
        }
        return responseValue;
    }

    private void executeScriptGetFileRequest(String openCpuSessionKey, String scriptOutputFilename, String outputPathname) throws IOException {
        block13: {
            URI scriptGetValueResponseUri = this.getScriptGetFileResponseUri(openCpuSessionKey, scriptOutputFilename);
            HttpGet httpGet = new HttpGet(scriptGetValueResponseUri);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    HttpEntity entity = response.getEntity();
                    Files.copy(entity.getContent(), Paths.get(outputPathname, new String[0]), new CopyOption[0]);
                    EntityUtils.consume((HttpEntity)entity);
                    break block13;
                }
                throw new ClientProtocolException(String.format("Unexpected response status: %d", statusCode));
            }
        }
    }

    private String executeScriptGetValueRequest(String openCpuSessionKey) throws IOException {
        String responseValue;
        block13: {
            URI scriptGetValueResponseUri = this.getScriptGetValueResponseUri(openCpuSessionKey);
            HttpGet httpGet = new HttpGet(scriptGetValueResponseUri);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    HttpEntity entity = response.getEntity();
                    responseValue = EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                    break block13;
                }
                throw new ClientProtocolException(String.format("Unexpected response status: %d", statusCode));
            }
        }
        return responseValue;
    }

    private String generateRandomString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private URI getScriptExecutionUri() {
        try {
            return new URI(this.getOpenCpuUri() + "library/base/R/identity");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getScriptGetValueResponseUri(String openCpuSessionKey) {
        try {
            return new URI(this.getOpenCpuUri() + "tmp/" + openCpuSessionKey + "/stdout");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getScriptGetFileResponseUri(String openCpuSessionKey, String fileId) {
        try {
            return new URI(this.getOpenCpuUri() + "tmp/" + openCpuSessionKey + "/files/" + fileId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getOpenCpuUri() {
        try {
            return new URIBuilder().setScheme(this.openCpuSettings.getScheme()).setHost(this.openCpuSettings.getHost()).setPort(this.openCpuSettings.getPort()).setPath(this.openCpuSettings.getRootPath()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

