package org.molgenis.r;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;

import java.util.Map;
import org.molgenis.script.core.Script;
import org.molgenis.script.core.ScriptRunner;
import org.molgenis.script.core.ScriptUtils;
import org.springframework.stereotype.Service;

@Service
public class RScriptRunner implements ScriptRunner {
  private static final String NAME = "R";

  private final RScriptExecutor rScriptExecutor;
  private static final String PARAM_OUTPUT_FILE = "outputFile";

  public RScriptRunner(RScriptExecutor rScriptExecutor) {
    this.rScriptExecutor = requireNonNull(rScriptExecutor);
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean hasFileOutput(Script script) {
    return ScriptUtils.hasScriptVariable(script, PARAM_OUTPUT_FILE);
  }

  @Override
  public String runScript(Script script, Map<String, Object> parameters) {
    String rScript = ScriptUtils.generateScript(script, parameters);
    String outputFile = getOutputFile(parameters);
    return rScriptExecutor.executeScript(rScript, outputFile);
  }

  private String getOutputFile(Map<String, Object> parameters) {
    Object outputFile = parameters.get(PARAM_OUTPUT_FILE);
    if (outputFile == null) {
      return null;
    }
    if (!(outputFile instanceof String)) {
      throw new RuntimeException(
          format(
              "Parameter outputFile is of type '%s' instead of '%s'",
              outputFile.getClass().getSimpleName(), String.class.getSimpleName()));
    }
    return (String) outputFile;
  }
}
