/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.search;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.molgenis.search.Hit;

public class SearchResult
implements Iterable<Hit> {
    private long totalHitCount = 0L;
    private List<Hit> searchHits = Collections.emptyList();
    private String errorMessage = null;

    public SearchResult(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public SearchResult(long totalHitCount, List<Hit> searchHits) {
        if (searchHits == null) {
            throw new IllegalArgumentException("SearchHits is null");
        }
        this.totalHitCount = totalHitCount;
        this.searchHits = searchHits;
    }

    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    public List<Hit> getSearchHits() {
        return Collections.unmodifiableList(this.searchHits);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Iterator<Hit> iterator() {
        return this.searchHits.iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

