/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.search;

import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class SearchController
implements InitializingBean {
    public static final String URI = "/search";
    private static final Logger logger = Logger.getLogger(SearchController.class);
    private SearchService searchService;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<SearchResult> search(@RequestBody SearchRequest request) {
        SearchResult result;
        try {
            result = this.searchService.search(request);
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
            result = new SearchResult(e.getMessage());
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Access-Control-Allow-Origin", "*");
        return new ResponseEntity((Object)result, (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.OPTIONS})
    public void preflightCors(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "POST");
        response.addHeader("Access-Control-Allow-Headers", "Accept, Content-Type, Origin");
    }
}

