/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.search;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.molgenis.framework.server.MolgenisSettings;
import org.molgenis.security.SecurityUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SearchSecurityHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = Logger.getLogger(SearchSecurityHandlerInterceptor.class);
    public static final String KEY_ACTION_ALLOW_ANONYMOUS_SEARCH = "api.search.allow.anonymous";
    private static final boolean DEFAULT_ACTION_ALLOW_ANONYMOUS_SEARCH = false;
    private final MolgenisSettings molgenisSettings;

    public SearchSecurityHandlerInterceptor(MolgenisSettings molgenisSettings) {
        if (molgenisSettings == null) {
            throw new IllegalArgumentException("MolgenisSettings is null");
        }
        this.molgenisSettings = molgenisSettings;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isAllowAnonymousSearch() || SecurityUtils.currentUserIsAuthenticated()) {
            return true;
        }
        response.sendError(401);
        return false;
    }

    private boolean isAllowAnonymousSearch() {
        try {
            String property = this.molgenisSettings.getProperty(KEY_ACTION_ALLOW_ANONYMOUS_SEARCH, Boolean.toString(false));
            return Boolean.valueOf(property);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn((Object)e);
            return false;
        }
    }
}

