/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.molgenis.data.Query;
import org.molgenis.data.support.QueryImpl;

public class SearchRequest {
    private String documentType;
    private QueryImpl query;
    private final List<String> fieldsToReturn;
    private String aggregateField1;
    private String aggregateField2;

    public SearchRequest() {
        this.fieldsToReturn = new ArrayList<String>();
    }

    public SearchRequest(String documentType, Query query, List<String> fieldsToReturn) {
        this.documentType = documentType;
        this.query = new QueryImpl(query);
        this.fieldsToReturn = fieldsToReturn;
    }

    public SearchRequest(String documentType, Query query, List<String> fieldsToReturn, String aggregateField1, String aggregateField2) {
        this(documentType, query, fieldsToReturn);
        this.aggregateField1 = aggregateField1;
        this.aggregateField2 = aggregateField2;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public Query getQuery() {
        if (this.query == null) {
            this.query = new QueryImpl();
        }
        return this.query;
    }

    public List<String> getFieldsToReturn() {
        return this.fieldsToReturn;
    }

    public String getAggregateField1() {
        return this.aggregateField1;
    }

    public String getAggregateField2() {
        return this.aggregateField2;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentType == null ? 0 : this.documentType.hashCode());
        result = 31 * result + (this.aggregateField1 == null ? 0 : this.aggregateField1.hashCode());
        result = 31 * result + (this.aggregateField2 == null ? 0 : this.aggregateField2.hashCode());
        result = 31 * result + (this.fieldsToReturn == null ? 0 : this.fieldsToReturn.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchRequest other = (SearchRequest)obj;
        if (this.documentType == null ? other.documentType != null : !this.documentType.equals(other.documentType)) {
            return false;
        }
        if (this.aggregateField1 == null ? other.aggregateField1 != null : !this.aggregateField1.equals(other.aggregateField1)) {
            return false;
        }
        if (this.aggregateField2 == null ? other.aggregateField2 != null : !this.aggregateField2.equals(other.aggregateField2)) {
            return false;
        }
        if (this.fieldsToReturn == null ? other.fieldsToReturn != null : !this.fieldsToReturn.equals(other.fieldsToReturn)) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals((Object)other.query));
    }
}

