/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.searchall.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.molgenis.core.gson.AutoGson;
import org.molgenis.searchall.model.AttributeResult;
import org.molgenis.searchall.model.AutoValue_EntityTypeResult;
import org.molgenis.searchall.model.Described;

@AutoGson(autoValueClass=AutoValue_EntityTypeResult.class)
public abstract class EntityTypeResult
implements Described {
    public abstract String getId();

    @Nullable
    public abstract String getPackageId();

    public abstract boolean isLabelMatch();

    public abstract boolean isDescriptionMatch();

    public abstract ImmutableList<AttributeResult> getAttributes();

    public abstract long getNrOfMatchingEntities();

    public boolean isMatch() {
        return this.isLabelMatch() || this.isDescriptionMatch() || !this.getAttributes().isEmpty() || this.getNrOfMatchingEntities() > 0L;
    }

    public static Builder builder() {
        return new AutoValue_EntityTypeResult.Builder();
    }

    public static abstract class Builder {
        public abstract Builder setId(String var1);

        public abstract Builder setLabel(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setPackageId(String var1);

        public abstract Builder setLabelMatch(boolean var1);

        public abstract Builder setDescriptionMatch(boolean var1);

        public abstract Builder setAttributes(List<AttributeResult> var1);

        public abstract Builder setNrOfMatchingEntities(long var1);

        public abstract EntityTypeResult build();
    }
}

