/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.searchall.service;

import com.google.common.base.Predicates;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.data.util.MetaUtils;
import org.molgenis.i18n.LanguageService;
import org.molgenis.searchall.model.AttributeResult;
import org.molgenis.searchall.model.EntityTypeResult;
import org.molgenis.searchall.model.PackageResult;
import org.molgenis.searchall.model.Result;
import org.springframework.stereotype.Component;

@Component
public class SearchAllService {
    private final DataService dataService;

    public SearchAllService(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    public Result searchAll(String searchTerm) {
        String lang = LanguageService.getCurrentUserLanguageCode();
        return Result.builder().setEntityTypes(this.dataService.findAll("sys_md_EntityType", EntityType.class).filter(Predicates.not(EntityTypeUtils::isSystemEntity)).filter(Predicates.not(EntityType::isAbstract)).map(entityType -> this.toEntityTypeResult(searchTerm, (EntityType)entityType, lang)).filter(EntityTypeResult::isMatch).collect(Collectors.toList())).setPackages(this.dataService.findAll("sys_md_Package", Package.class).filter(Predicates.not(MetaUtils::isSystemPackage)).map(PackageResult::create).filter(packageResult -> packageResult.isLabelOrDescriptionMatch(searchTerm)).collect(Collectors.toList())).build();
    }

    private EntityTypeResult toEntityTypeResult(String searchTerm, EntityType entityType, String lang) {
        EntityTypeResult.Builder builder = EntityTypeResult.builder().setId(entityType.getId()).setLabel(entityType.getLabel(lang)).setDescription(entityType.getDescription(lang));
        if (entityType.getPackage() != null) {
            builder.setPackageId(entityType.getPackage().getId());
        }
        builder.setLabelMatch(StringUtils.containsIgnoreCase((CharSequence)entityType.getLabel(lang), (CharSequence)searchTerm)).setDescriptionMatch(StringUtils.containsIgnoreCase((CharSequence)entityType.getDescription(lang), (CharSequence)searchTerm)).setAttributes(this.matchingAttributes(searchTerm, entityType.getAllAttributes(), lang)).setNrOfMatchingEntities(this.dataService.count(entityType.getId(), new QueryImpl().search(searchTerm)));
        return builder.build();
    }

    private List<AttributeResult> matchingAttributes(String searchterm, Iterable<Attribute> allAttributes, String lang) {
        return Streams.stream(allAttributes).map(attribute -> AttributeResult.create(attribute, lang)).filter(attributeResult -> attributeResult.isLabelOrDescriptionMatch(searchterm)).collect(Collectors.toList());
    }
}

