/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.searchall.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface Described {
    public String getLabel();

    @Nullable
    @CheckForNull
    public String getDescription();

    default public boolean isLabelOrDescriptionMatch(String searchterm) {
        return this.isLabelMatch(searchterm) || this.isDescriptionMatch(searchterm);
    }

    default public boolean isLabelMatch(String searchterm) {
        return StringUtils.containsIgnoreCase((CharSequence)this.getLabel(), (CharSequence)searchterm);
    }

    default public boolean isDescriptionMatch(String searchterm) {
        return StringUtils.containsIgnoreCase((CharSequence)this.getDescription(), (CharSequence)searchterm);
    }
}

