/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.searchall.controller;

import java.util.Objects;
import org.molgenis.searchall.model.Result;
import org.molgenis.searchall.service.SearchAllService;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/searchAll"})
public class SearchAllPluginController
extends PluginController {
    public static final String ID = "searchAll";
    public static final String URI = "/plugin/searchAll";
    private static final String KEY_BASE_URL = "baseUrl";
    public static final String NAVIGATOR = "navigator";
    public static final String DATAEXPLORER = "dataexplorer";
    private final SearchAllService searchAllService;
    private final MenuReaderService menuReaderService;

    public SearchAllPluginController(MenuReaderService menuReaderService, SearchAllService searchAllService) {
        super(URI);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.searchAllService = Objects.requireNonNull(searchAllService);
    }

    @GetMapping(value={"/**"})
    public String init(Model model) {
        model.addAttribute(KEY_BASE_URL, (Object)this.menuReaderService.findMenuItemPath(ID));
        model.addAttribute("navigatorBaseUrl", (Object)this.menuReaderService.findMenuItemPath(NAVIGATOR));
        model.addAttribute("dataExplorerBaseUrl", (Object)this.menuReaderService.findMenuItemPath(DATAEXPLORER));
        return "view-search-all";
    }

    @GetMapping(value={"/search"}, produces={"application/json"})
    @ResponseBody
    public Result searchAll(@RequestParam(value="term") String searchterm) {
        return this.searchAllService.searchAll(searchterm);
    }
}

