/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.runas.RunnableAsSystem;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.aop.framework.Advised;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RunAsSystemProxy
implements Advice,
MethodInterceptor {
    private final Object targetObject;

    public RunAsSystemProxy(Object targetObject) {
        this.targetObject = targetObject;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method interfaceMethod;
        Class clazz = this.targetObject instanceof Advised ? ((Advised)this.targetObject).getTargetClass() : this.targetObject.getClass();
        Method targetMethod = clazz.getMethod((interfaceMethod = invocation.getMethod()).getName(), interfaceMethod.getParameterTypes());
        if (!targetMethod.isAnnotationPresent(RunAsSystem.class)) {
            return invocation.proceed();
        }
        return RunAsSystemProxy.runAsSystem(() -> ((MethodInvocation)invocation).proceed());
    }

    public static <T, X extends Throwable> T runAsSystem(RunnableAsSystem<T, X> runnable) throws X {
        SecurityContext origCtx = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.setContext((SecurityContext)SecurityContextHolder.createEmptyContext());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new SystemSecurityToken());
            T t = runnable.run();
            return t;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)origCtx);
        }
    }
}

