/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class RunAsSystemBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (bean instanceof Advised && ((Advised)bean).getTargetClass() != null) {
            Advised advised = (Advised)bean;
            for (Method method : advised.getTargetClass().getMethods()) {
                if (!method.isAnnotationPresent(RunAsSystem.class)) continue;
                advised.addAdvice((Advice)new RunAsSystemProxy(bean));
                return bean;
            }
        } else {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(RunAsSystem.class)) continue;
                ProxyFactory pf = new ProxyFactory();
                pf.setTarget(bean);
                pf.setInterfaces((Class[])clazz.getInterfaces());
                pf.addAdvice((Advice)new RunAsSystemProxy(bean));
                return pf.getProxy();
            }
        }
        return bean;
    }
}

