/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.security.core.Permission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUtils {
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final String AUTHORITY_SU = "ROLE_SU";
    public static final String AUTHORITY_ANONYMOUS = "ROLE_ANONYMOUS";
    public static final String AUTHORITY_PLUGIN_PREFIX = "ROLE_PLUGIN_";
    public static final String AUTHORITY_PLUGIN_READ_PREFIX = "ROLE_PLUGIN_" + (Object)((Object)Permission.READ) + "_";
    public static final String AUTHORITY_PLUGIN_WRITE_PREFIX = "ROLE_PLUGIN_" + (Object)((Object)Permission.WRITE) + "_";
    public static final String AUTHORITY_PLUGIN_COUNT_PREFIX = "ROLE_PLUGIN_" + (Object)((Object)Permission.COUNT) + "_";
    public static final String AUTHORITY_PLUGIN_WRITEMETA_PREFIX = "ROLE_PLUGIN_" + (Object)((Object)Permission.WRITEMETA) + "_";
    public static final String AUTHORITY_ENTITY_PREFIX = "ROLE_ENTITY_";
    public static final String AUTHORITY_ENTITY_READ_PREFIX = "ROLE_ENTITY_" + (Object)((Object)Permission.READ) + "_";
    public static final String AUTHORITY_ENTITY_WRITE_PREFIX = "ROLE_ENTITY_" + (Object)((Object)Permission.WRITE) + "_";
    public static final String AUTHORITY_ENTITY_COUNT_PREFIX = "ROLE_ENTITY_" + (Object)((Object)Permission.COUNT) + "_";
    public static final String AUTHORITY_ENTITY_WRITEMETA_PREFIX = "ROLE_ENTITY_" + (Object)((Object)Permission.WRITEMETA) + "_";

    public static String getCurrentUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        return SecurityUtils.getUsername(authentication);
    }

    public static String getUsername(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserDetails) {
            return ((UserDetails)principal).getUsername();
        }
        return principal.toString();
    }

    public static boolean currentUserHasRole(String ... roles) {
        if (roles == null || roles.length == 0) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Collection authorities = authentication.getAuthorities();
            for (String role : roles) {
                for (GrantedAuthority grantedAuthority : authorities) {
                    if (!role.equals(grantedAuthority.getAuthority())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean currentUserIsSuOrSystem() {
        return SecurityUtils.currentUserIsSu() || SecurityUtils.currentUserisSystem();
    }

    public static boolean currentUserIsSu() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Collection authorities = authentication.getAuthorities();
        if (authorities == null) {
            throw new IllegalStateException("No current user logged in");
        }
        for (GrantedAuthority authority : authorities) {
            if (!authority.getAuthority().equals(AUTHORITY_SU)) continue;
            return true;
        }
        return false;
    }

    public static boolean currentUserisSystem() {
        return SecurityUtils.getCurrentUsername().equals("SYSTEM");
    }

    public static boolean currentUserIsAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Object principal = authentication.getPrincipal();
        String username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return authentication.isAuthenticated() && !username.equals(ANONYMOUS_USERNAME);
    }

    public static String[] defaultPluginAuthorities(String ... pluginIds) {
        ArrayList<String> pluginAuthorities = new ArrayList<String>();
        pluginAuthorities.add(AUTHORITY_SU);
        if (pluginIds != null) {
            for (String pluginId : pluginIds) {
                pluginAuthorities.add(SecurityUtils.getPluginReadAuthority(pluginId));
                pluginAuthorities.add(SecurityUtils.getPluginWriteAuthority(pluginId));
            }
        }
        return pluginAuthorities.toArray(new String[0]);
    }

    public static String getPluginReadAuthority(String pluginId) {
        return AUTHORITY_PLUGIN_READ_PREFIX + pluginId;
    }

    public static String getPluginWriteAuthority(String pluginId) {
        return AUTHORITY_PLUGIN_WRITE_PREFIX + pluginId;
    }

    public static List<String> getEntityAuthorities(String entityName) {
        ArrayList<String> authorities = new ArrayList<String>();
        for (Permission permission : Permission.values()) {
            String authority = String.format("%s%s_%s", AUTHORITY_ENTITY_PREFIX, permission.name(), entityName);
            authorities.add(authority);
        }
        return authorities;
    }

    public static boolean isSessionExpired(HttpServletRequest request) {
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }
}

