/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.context.support.WithSecurityContextTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@TestExecutionListeners(listeners={WithSecurityContextTestExecutionListener.class})
@ContextConfiguration(classes={Config.class})
public class RunAsSystemAspectTest
extends AbstractTestNGSpringContextTests {
    private static Authentication AUTHENTICATION_PREVIOUS;

    @BeforeClass
    public void setUpBeforeClass() {
        AUTHENTICATION_PREVIOUS = SecurityContextHolder.getContext().getAuthentication();
    }

    @AfterClass
    public static void tearDownAfterClass() {
        SecurityContextHolder.getContext().setAuthentication(AUTHENTICATION_PREVIOUS);
    }

    @Test
    @WithMockUser
    public void invoke() {
        Assert.assertEquals((String)this.getCurrentUsername(), (String)"user");
        Assert.assertEquals((String)((String)RunAsSystemAspect.runAsSystem(this::getCurrentUsername)), (String)"SYSTEM");
        Assert.assertEquals((String)this.getCurrentUsername(), (String)"user");
    }

    private String getCurrentUsername() {
        return ((User)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
    }

    @Configuration
    public static class Config {
    }
}

