/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;

public class SidUtils {
    public static final String ROLE_PREFIX = "ROLE_";

    private SidUtils() {
    }

    public static Sid createUserSid(String username) {
        if (username.equals("anonymous")) {
            return SidUtils.createAnonymousSid();
        }
        return new PrincipalSid(username);
    }

    public static Sid createRoleSid(String rolename) {
        return SidUtils.createAuthoritySid(SidUtils.createRoleAuthority(rolename));
    }

    public static Sid createAuthoritySid(String authority) {
        return new GrantedAuthoritySid(authority);
    }

    public static String createRoleAuthority(String roleName) {
        return ROLE_PREFIX + roleName;
    }

    public static String getRoleName(String authority) {
        if (!authority.startsWith(ROLE_PREFIX)) {
            throw new IllegalArgumentException("Not an authority: " + authority);
        }
        return authority.substring(ROLE_PREFIX.length());
    }

    private static Sid createAnonymousSid() {
        return new GrantedAuthoritySid("ROLE_ANONYMOUS");
    }
}

