/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.molgenis.security.core.SidUtils;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SidUtilsTest {
    @Test
    public void testCreateSidUser() {
        Sid sid = SidUtils.createUserSid((String)"username");
        Assert.assertEquals((Object)sid, (Object)new PrincipalSid("username"));
    }

    @Test
    public void testCreateSidUsernameAnonymous() {
        Sid sid = SidUtils.createUserSid((String)"anonymous");
        Assert.assertEquals((Object)sid, (Object)new GrantedAuthoritySid("ROLE_ANONYMOUS"));
    }

    @Test
    public void testCreateSidRole() {
        Sid sid = SidUtils.createRoleSid((String)"NAME");
        Assert.assertEquals((Object)sid, (Object)new GrantedAuthoritySid((GrantedAuthority)new SimpleGrantedAuthority("ROLE_NAME")));
    }

    @Test
    public void testCreateRoleAuthority() {
        Assert.assertEquals((String)"ROLE_NAME", (String)SidUtils.createRoleAuthority((String)"NAME"));
    }
}

