/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.security.acls.domain.AbstractPermission;

public class PermissionSet
extends AbstractPermission {
    private String name;
    public static final int READ_META_MASK = 1;
    public static final int COUNT_MASK = 2;
    public static final int READ_MASK = 4;
    public static final int WRITE_MASK = 8;
    public static final int WRITEMETA_MASK = 16;
    public static final PermissionSet READMETA = new PermissionSet("Read Meta", 1, 'M');
    public static final PermissionSet COUNT = new PermissionSet("Count", 2, 'C');
    public static final PermissionSet READ = new PermissionSet("Read", 4, 'R');
    public static final PermissionSet WRITE = new PermissionSet("Write", 8, 'W');
    public static final PermissionSet WRITEMETA = new PermissionSet("Manage", 16, 'A');

    protected PermissionSet(String name, int mask) {
        super(mask);
        this.name = name;
    }

    public PermissionSet(String name, int mask, char code) {
        super(mask, code);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    private String code() {
        return Stream.of("permission", ((Object)((Object)this)).getClass().getSimpleName(), this.name()).collect(Collectors.joining("."));
    }

    public MessageSourceResolvable getName() {
        return new DefaultMessageSourceResolvable(new String[]{this.code()}, null, this.name());
    }
}

