/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionSet;
import org.springframework.stereotype.Component;

@Component
public class PermissionRegistry {
    private SetMultimap<Permission, PermissionSet> mapping = HashMultimap.create();

    public void addMapping(Permission permission, PermissionSet ... permissionSet) {
        this.mapping.putAll((Object)permission, Arrays.asList(permissionSet));
    }

    public Set<PermissionSet> getPermissions(Permission permission) {
        return this.mapping.get((Object)permission);
    }

    public Map<PermissionSet, Set<Permission>> getPermissionSets() {
        return this.mapping.entries().stream().collect(Collectors.groupingBy(Map.Entry::getValue, LinkedHashMap::new, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
    }
}

