/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.molgenis.security.core.runas.RunnableAsSystem;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Order(value=-2147483647)
@Aspect
@Component
public class RunAsSystemAspect {
    @Around(value="@annotation(RunAsSystem)")
    public Object aroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return RunAsSystemAspect.runAsSystem(() -> ((ProceedingJoinPoint)joinPoint).proceed());
    }

    public static void runAsSystem(Runnable runnable) {
        RunAsSystemAspect.runAsSystem(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T, X extends Throwable> T runAsSystem(RunnableAsSystem<T, X> runnable) throws X {
        SecurityContext origCtx = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.setContext((SecurityContext)SecurityContextHolder.createEmptyContext());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new SystemSecurityToken());
            T t = runnable.run();
            return t;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)origCtx);
        }
    }
}

