/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;

public interface Permission {
    public String name();

    public String getDefaultDescription();

    default public String getType() {
        return this.getClass().getSimpleName();
    }

    default public MessageSourceResolvable getDescription() {
        String code = Stream.of("permission", this.getType(), this.name(), "description").collect(Collectors.joining("."));
        return new DefaultMessageSourceResolvable(new String[]{code}, null, this.getDefaultDescription());
    }

    default public MessageSourceResolvable getName() {
        String code = Stream.of("permission", this.getType(), this.name(), "name").collect(Collectors.joining("."));
        return new DefaultMessageSourceResolvable(new String[]{code}, null, this.name());
    }
}

