/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.molgenis.security.core.SidUtils;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SidUtilsTest {
    private Authentication authenticationPrevious;

    @BeforeMethod
    public void setUpBeforeMethod() {
        this.authenticationPrevious = SecurityContextHolder.getContext().getAuthentication();
    }

    @AfterMethod
    public void tearDownAfterMethod() {
        SecurityContextHolder.getContext().setAuthentication(this.authenticationPrevious);
    }

    @Test
    public void createSecurityContextSidUser() {
        String principal = "username";
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)principal, null));
        Assert.assertEquals((Object)SidUtils.createSecurityContextSid(), (Object)new PrincipalSid(principal));
    }

    @Test
    public void createSecurityContextSidSystem() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)SystemSecurityToken.getInstance());
        Assert.assertEquals((Object)SidUtils.createSecurityContextSid(), (Object)new GrantedAuthoritySid("ROLE_SYSTEM"));
    }

    @Test
    public void createSecurityContextSidAnonymous() {
        SecurityContextHolder.getContext().setAuthentication(null);
        Assert.assertEquals((Object)SidUtils.createSecurityContextSid(), (Object)new GrantedAuthoritySid("ROLE_ANONYMOUS"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void createSecurityContextNoPrincipal() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken(null, null));
        SidUtils.createSecurityContextSid();
    }

    @Test
    public void testCreateSidUser() {
        Sid sid = SidUtils.createUserSid((String)"username");
        Assert.assertEquals((Object)sid, (Object)new PrincipalSid("username"));
    }

    @Test
    public void testCreateSidUsernameAnonymous() {
        Sid sid = SidUtils.createUserSid((String)"anonymous");
        Assert.assertEquals((Object)sid, (Object)new GrantedAuthoritySid("ROLE_ANONYMOUS"));
    }

    @Test
    public void testCreateSidRole() {
        Sid sid = SidUtils.createRoleSid((String)"NAME");
        Assert.assertEquals((Object)sid, (Object)new GrantedAuthoritySid((GrantedAuthority)new SimpleGrantedAuthority("ROLE_NAME")));
    }

    @Test
    public void testCreateRoleAuthority() {
        Assert.assertEquals((String)"ROLE_NAME", (String)SidUtils.createRoleAuthority((String)"NAME"));
    }
}

