/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.utils;

import java.util.Collection;
import javax.annotation.Nullable;
import org.molgenis.security.core.MappedAuthenticatedPrincipal;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUtils {
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final String AUTHORITY_SU = "ROLE_SU";
    public static final String AUTHORITY_ANONYMOUS = "ROLE_ANONYMOUS";
    public static final String AUTHORITY_USER = "ROLE_USER";
    public static final String ROLE_SYSTEM = "ROLE_SYSTEM";
    public static final String ROLE_ACL_TAKE_OWNERSHIP = "ROLE_ACL_TAKE_OWNERSHIP";
    public static final String ROLE_ACL_MODIFY_AUDITING = "ROLE_ACL_MODIFY_AUDITING";
    public static final String ROLE_ACL_GENERAL_CHANGES = "ROLE_ACL_GENERAL_CHANGES";

    private SecurityUtils() {
    }

    @Nullable
    public static String getCurrentUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        return SecurityUtils.getUsername(authentication);
    }

    @Nullable
    private static String getUsername(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        String username = principal == null || principal instanceof SystemSecurityToken.SystemPrincipal ? null : (principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : (principal instanceof MappedAuthenticatedPrincipal ? ((MappedAuthenticatedPrincipal)principal).getMappedName() : principal.toString()));
        return username;
    }

    public static boolean currentUserHasRole(String ... roles) {
        if (roles == null || roles.length == 0) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Collection authorities = authentication.getAuthorities();
            if (authorities == null) {
                throw new IllegalStateException("No user currently logged in");
            }
            for (String role : roles) {
                for (GrantedAuthority grantedAuthority : authorities) {
                    if (!role.equals(grantedAuthority.getAuthority())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean currentUserIsSuOrSystem() {
        return SecurityUtils.currentUserIsSu() || SecurityUtils.currentUserIsSystem();
    }

    public static boolean currentUserIsSu() {
        return SecurityUtils.currentUserHasRole(AUTHORITY_SU);
    }

    public static boolean currentUserIsSystem() {
        return SecurityUtils.currentUserHasRole(ROLE_SYSTEM);
    }

    public static boolean currentUserIsAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated() && !SecurityUtils.currentUserIsAnonymous();
    }

    public static boolean currentUserIsAnonymous() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null || SecurityUtils.currentUserHasRole(AUTHORITY_ANONYMOUS);
    }
}

