/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.PermissionSet;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
implements PermissionService {
    private MutableAclService mutableAclService;

    public PermissionServiceImpl(MutableAclService mutableAclService) {
        this.mutableAclService = Objects.requireNonNull(mutableAclService);
    }

    @Override
    public void grant(Map<ObjectIdentity, PermissionSet> objectPermissionMap, Sid sid) {
        objectPermissionMap.forEach((objectIdentity, permissionSet) -> this.grant((ObjectIdentity)objectIdentity, (PermissionSet)((Object)permissionSet), sid));
    }

    @Override
    public void grant(ObjectIdentity objectIdentity, PermissionSet permissionSet, Sid sid) {
        MutableAcl acl = (MutableAcl)this.mutableAclService.readAclById(objectIdentity);
        acl.insertAce(acl.getEntries().size(), (Permission)permissionSet, sid, true);
        this.mutableAclService.updateAcl(acl);
    }

    @Override
    public boolean exists(ObjectIdentity objectIdentity, Sid sid) {
        MutableAcl acl = (MutableAcl)this.mutableAclService.readAclById(objectIdentity, Collections.singletonList(sid));
        return acl.getEntries().stream().anyMatch(ace -> ace.getSid().equals((Object)sid));
    }
}

