/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import java.util.Collections;
import java.util.Map;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.InvalidUseOfMatchersException;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.PermissionServiceImpl;
import org.molgenis.security.core.PermissionSet;
import org.molgenis.test.AbstractMockitoTest;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.collections.Maps;

public class PermissionServiceImplTest
extends AbstractMockitoTest {
    @Mock
    private MutableAclService mutableAclService;
    private PermissionService permissionService;

    @BeforeMethod
    public void beforeMethod() {
        this.permissionService = new PermissionServiceImpl(this.mutableAclService);
    }

    @Test
    public void testGrantPermissionSetForSingleObject() {
        Sid sid = (Sid)Mockito.mock(Sid.class);
        MutableAcl acl = (MutableAcl)Mockito.mock(MutableAcl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)acl.getEntries().size()).thenReturn((Object)1);
        ObjectIdentity objectIdentity = (ObjectIdentity)Mockito.mock(ObjectIdentity.class);
        Mockito.when((Object)this.mutableAclService.readAclById(objectIdentity)).thenReturn((Object)acl);
        this.permissionService.grant(objectIdentity, PermissionSet.WRITE, sid);
        ((MutableAcl)Mockito.verify((Object)acl, (VerificationMode)Mockito.times((int)1))).insertAce(1, (Permission)PermissionSet.WRITE, sid, true);
        ((MutableAclService)Mockito.verify((Object)this.mutableAclService, (VerificationMode)Mockito.times((int)1))).updateAcl(acl);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mutableAclService});
    }

    @Test
    public void testGrantPermissionSetsForMultipleObjects() {
        Sid sid = (Sid)Mockito.mock(Sid.class);
        MutableAcl acl1 = (MutableAcl)Mockito.mock(MutableAcl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)acl1.getEntries().size()).thenReturn((Object)1);
        ObjectIdentity objectIdentity1 = (ObjectIdentity)Mockito.mock(ObjectIdentity.class);
        MutableAcl acl2 = (MutableAcl)Mockito.mock(MutableAcl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)acl2.getEntries().size()).thenReturn((Object)1);
        ObjectIdentity objectIdentity2 = (ObjectIdentity)Mockito.mock(ObjectIdentity.class);
        Mockito.when((Object)this.mutableAclService.readAclById((ObjectIdentity)Mockito.any(ObjectIdentity.class))).thenAnswer(invocation -> {
            Object argument = invocation.getArguments()[0];
            if (argument.equals(objectIdentity1)) {
                return acl1;
            }
            if (argument.equals(objectIdentity2)) {
                return acl2;
            }
            throw new InvalidUseOfMatchersException("");
        });
        Map permissionSetMap = Maps.newHashMap();
        permissionSetMap.put(objectIdentity1, PermissionSet.COUNT);
        permissionSetMap.put(objectIdentity2, PermissionSet.WRITEMETA);
        this.permissionService.grant(permissionSetMap, sid);
        ((MutableAcl)Mockito.verify((Object)acl1, (VerificationMode)Mockito.times((int)1))).insertAce(1, (Permission)PermissionSet.COUNT, sid, true);
        ((MutableAclService)Mockito.verify((Object)this.mutableAclService, (VerificationMode)Mockito.times((int)1))).updateAcl(acl1);
        ((MutableAcl)Mockito.verify((Object)acl2, (VerificationMode)Mockito.times((int)1))).insertAce(1, (Permission)PermissionSet.WRITEMETA, sid, true);
        ((MutableAclService)Mockito.verify((Object)this.mutableAclService, (VerificationMode)Mockito.times((int)1))).updateAcl(acl2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mutableAclService});
    }

    @Test
    public void testExists() {
        ObjectIdentity objectIdentity = (ObjectIdentity)Mockito.mock(ObjectIdentity.class);
        Sid sid = (Sid)Mockito.mock(Sid.class);
        MutableAcl acl = (MutableAcl)Mockito.mock(MutableAcl.class);
        Mockito.when((Object)this.mutableAclService.readAclById(objectIdentity, Collections.singletonList(sid))).thenReturn((Object)acl);
        AccessControlEntry ace = (AccessControlEntry)Mockito.mock(AccessControlEntry.class);
        Mockito.when((Object)ace.getSid()).thenReturn((Object)sid);
        Mockito.when((Object)acl.getEntries()).thenReturn(Collections.singletonList(ace));
        Assert.assertTrue((boolean)this.permissionService.exists(objectIdentity, sid));
    }

    @Test
    public void testExistsNotExists() {
        ObjectIdentity objectIdentity = (ObjectIdentity)Mockito.mock(ObjectIdentity.class);
        Sid sid = (Sid)Mockito.mock(Sid.class);
        MutableAcl acl = (MutableAcl)Mockito.mock(MutableAcl.class);
        Mockito.when((Object)this.mutableAclService.readAclById(objectIdentity, Collections.singletonList(sid))).thenReturn((Object)acl);
        Assert.assertFalse((boolean)this.permissionService.exists(objectIdentity, sid));
    }
}

